<?php
require '../function/connect.php';
require '../main/integration.php';

// Cek apakah hari ini Jumat (5 = Jumat dalam format ISO-8601)
if (date('N') == 5) {
    $sql = "SELECT id_user, SUM(total) AS total_deposit 
            FROM tb_transaksi 
            WHERE transaksi = 'deposit' 
            AND status = 'success' 
            AND tanggal >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) 
            GROUP BY id_user";

    $result = $koneksi->query($sql);
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $id_user = $row['id_user'];
            $total_deposit = $row['total_deposit'];

            // Hitung cashback 5%
            $cashback = $total_deposit * 0.05;

            // Panggil API transaksi (cek apakah berhasil)
            $Transaksi = json_decode($ZH->Transaksi($id_user, $cashback, 'deposit'), true);

            if ($Transaksi && isset($Transaksi['status']) && $Transaksi['status'] == 'success') {
                // Update saldo dengan prepared statement
                $stmt = $koneksi->prepare("UPDATE tb_saldo SET active = active + ? WHERE id_user = ?");
                $stmt->bind_param("di", $cashback, $id_user);
                $stmt->execute();
                $stmt->close();

                // Catat transaksi cashback
                $trxid = uniqid('CB_');
                $stmt = $koneksi->prepare("INSERT INTO tb_transaksi (id_user, transaksi, total, metode, bonus, keterangan, status, trxid, tanggal) 
                                           VALUES (?, 'bonus', ?, 'cashback', 'yes', 'Bonus Cashback Mingguan', 'success', ?, NOW())");
                $stmt->bind_param("ids", $id_user, $cashback, $trxid);
                $stmt->execute();
                $stmt->close();
            }
        }
    }

    echo "Bonus cashback mingguan berhasil diproses.";
} else {
    echo "Hari ini bukan Jumat, proses dihentikan.";
}
?>
