<?php
include '../../function/connect.php';
session_start();

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

$user_ip = getUserIP();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!isset($_POST['token']) || $_POST['token'] !== $_SESSION['token']) {
        header("location:../index.php?error=invalid");
        exit();
    }
    if (!empty($_POST['username']) && !empty($_POST['password'])) {
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);

        $stmt = $koneksi->prepare("SELECT username, password, level FROM tb_admin WHERE LOWER(username) = LOWER(?) LIMIT 1");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();
        $stmt->close();

        if ($user && password_verify($password, $user['password'])) {
            session_regenerate_id(true);

            $_SESSION['username'] = htmlspecialchars($user['username'], ENT_QUOTES, 'UTF-8');
            $_SESSION['status'] = "login";
            $_SESSION['level'] = htmlspecialchars($user['level'], ENT_QUOTES, 'UTF-8');
            $_SESSION['ip'] = $user_ip;
            $_SESSION['last_activity'] = time();
            $_SESSION['last_regenerate'] = time();
            
            header("location:../template/");
            exit();
            unset($_SESSION['token']);
        } else {
            header("location:../index.php?error=invalid");
            exit();
        }
    } else {
        header("location:../../index.php?error=empty");
        exit();
    }
} else {
    header("location:../../index.php");
    exit();
}
