<?php
date_default_timezone_set('Asia/Jakarta');
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', '../error.log');
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);

include '../../function/connect.php';
session_start();

unset($_SESSION['token']);

if (!isset($_SESSION['username']) || empty($_SESSION['username'])) {
    session_destroy();
    header("location:../index.php");
    exit();
}

function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

$user_ip = getUserIP();
$session_ip = isset($_SESSION['ip']) ? $_SESSION['ip'] : '';

if ($session_ip && $session_ip !== $user_ip) {
    session_destroy();
    header("location:../index.php");
    exit();
}

if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > 600)) {
    session_unset();
    session_destroy();
    header("Location: ../index.php");
    exit();
}
$_SESSION['last_activity'] = time();

if (!isset($_SESSION['last_regenerate']) || time() - $_SESSION['last_regenerate'] > 300) {
    session_regenerate_id(true);
    $_SESSION['last_regenerate'] = time();
}

// Validasi user dari database
$que = mysqli_query($koneksi, "SELECT * FROM tb_admin WHERE username = '" . mysqli_real_escape_string($koneksi, $_SESSION['username']) . "'");
$c = mysqli_fetch_array($que);
if (!$c) {
    session_destroy();
    header("location:../index.php");
    exit();
}

// Data website
$cuk       = mysqli_query($koneksi, "SELECT * FROM tb_web");
$cek_web   = mysqli_fetch_array($cuk);
$urlweb    = htmlspecialchars($cek_web['url'], ENT_QUOTES, 'UTF-8');
$logo      = htmlspecialchars($cek_web['logo'], ENT_QUOTES, 'UTF-8');
$icon      = htmlspecialchars($cek_web['icon_web'], ENT_QUOTES, 'UTF-8');
$title     = htmlspecialchars($cek_web['title'], ENT_QUOTES, 'UTF-8');
$deskripsi = htmlspecialchars($cek_web['deskripsi'], ENT_QUOTES, 'UTF-8');
$keyword   = htmlspecialchars($cek_web['keyword'], ENT_QUOTES, 'UTF-8');
$endpoint  = htmlspecialchars($cek_web['endpoint'], ENT_QUOTES, 'UTF-8');
$pisah     = explode('|', $title);
$judul     = trim($pisah[0]);
?>

<!DOCTYPE html>
<html dir="ltr" lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="<?php echo $deskripsi ?>">
    <meta name="author" content="<?php echo $urlweb ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo $logo ?>">
    <title><?php echo $title; ?></title>
    <link href="../assets/libs/datatables.net-bs4/css/dataTables.bootstrap4.css" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="../assets/libs/select2/dist/css/select2.min.css">
    <link href="../dist/css/style.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body>
    <div class="preloader">
        <div class="lds-ripple">
            <div class="lds-pos"></div>
            <div class="lds-pos"></div>
        </div>
    </div>
    <div id="main-wrapper">
        <header class="topbar">
            <nav class="navbar top-navbar navbar-expand-md navbar-dark">
                <div class="navbar-header">
                    <a class="nav-toggler waves-effect waves-light d-block d-md-none" href="javascript:void(0)">
                        <i class="ti-menu ti-close"></i>
                    </a>
                    <div class="navbar-brand">
                        <a href="index.php" class="logo">
                            <b class="logo-icon">
                                <img style="width: 200px" src="<?php echo $logo ?>" alt="<?php echo $judul ?>" class="light-logo container-fluid" />
                            </b>
                            <a class="sidebartoggler d-none d-md-block" href="javascript:void(0)" data-sidebartype="mini-sidebar">
                                <i class="mdi mdi-toggle-switch mdi-toggle-switch-off font-20"></i>
                            </a>
                        </div>
                        <a class="topbartoggler d-block d-md-none waves-effect waves-light" href="javascript:void(0)" data-toggle="collapse" data-target="#navbarSupportedContent"
                        aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="ti-more"></i>
                    </a>
                </div>
                    <div class="navbar-collapse collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav float-right ml-auto">
                                    <li class="nav-item dropdown">
                                        <a class="nav-link dropdown-toggle waves-effect waves-dark pro-pic" href="" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                            <img src="https://www.hotelbooqi.com/wp-content/uploads/2021/12/128-1280406_view-user-icon-png-user-circle-icon-png.png" alt="user" class="rounded-circle" width="40">
                                            <span class="m-l-5 font-medium d-none d-sm-inline-block"><?php echo $c['nama_lengkap']; ?><i class="mdi mdi-chevron-down"></i></span>
                                        </a>
                                        <div class="dropdown-menu dropdown-menu-right user-dd animated flipInY">
                                            <span class="with-arrow">
                                                <span class="bg-primary"></span>
                                            </span>
                                            <div class="d-flex no-block align-items-center p-15 bg-primary text-white m-b-10">
                                                <div class="">
                                                    <img src="https://www.hotelbooqi.com/wp-content/uploads/2021/12/128-1280406_view-user-icon-png-user-circle-icon-png.png" alt="user" class="rounded-circle" width="60">
                                                </div>
                                                <div class="m-l-10">
                                                    <h4 class="m-b-0"><?php echo $c['nama_lengkap']; ?></h4>
                                                    <p class=" m-b-0">Level : <?php echo $c['level']; ?></p>
                                                </div>
                                            </div>
                                            <div class="profile-dis scrollable">
                                                <a class="dropdown-item" href="?page=admin">
                                                    <i class="fa fa-user m-r-5 m-l-5"></i> Profil Admin
                                                </a>
                                                <a class="dropdown-item" href="../function/logout.php">
                                                    <i class="fa fa-power-off m-r-5 m-l-5"></i> Logout
                                                </a>
                                            </div>
                                        </div>
                                    </li>
                                </ul>
                            </div>
                            </nav>
                        </header>
                        <aside class="left-sidebar">
                            <div class="scroll-sidebar">
                                <nav class="sidebar-nav">
                                    <ul id="sidebarnav">
                                        <li class="sidebar-item"> 
                                            <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=dashboard" aria-expanded="false">
                                            <i class="fa-solid fa-house fa-beat"></i>
                                                <span class="hide-menu">Dashboard</span>
                                            </a>
                                        </li>
                                        <li class="sidebar-item"> 
                                            <a class="sidebar-link has-arrow waves-effect waves-dark" href="javascript:void(0)" aria-expanded="false">
                                            <i class="fa-solid fa-layer-group"></i>
                                                <span class="hide-menu">Menu Game</span>
                                            </a>
                                            <ul aria-expanded="false" class="collapse first-level">
                                                <li class="sidebar-item">
                                                    <a href="?page=mtgame" class="sidebar-link">
                                                        <i class="fa-brands fa-react"></i>
                                                        <span class="hide-menu">API Game Settings</span>
                                                    </a>
                                                </li>
                                                </ul>
                                            </li>
                                        <?php
                                        if ($c['level'] == "superadmin") {
                                            ?>
                                            <li class="nav-small-cap">
                                                <i class="mdi mdi-dots-horizontal"></i>
                                                <span class="hide-menu">Informasi</span>
                                            </li>
                                            <li class="sidebar-item"> 
                                                <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=promosi" aria-expanded="false">
                                                    <i class="fa-solid fa-scale-balanced"></i>
                                                    <span class="hide-menu">Promosi</span>
                                                </a>
                                            </li>
                                               <li class="sidebar-item"> 
                                                <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=news" aria-expanded="false">
                                                    <i class="fa-solid fa-newspaper"></i>
                                                    <span class="hide-menu">Berita</span>
                                                </a>
                                            </li>
                                            <?php
                                        }
                                        ?>
                                        
                                        <li class="nav-small-cap">
                                            <i class="mdi mdi-dots-horizontal"></i>
                                            <span class="hide-menu">Transaksi</span>
                                        </li>
                                        <li class="sidebar-item"> 
                                            <a class="sidebar-link has-arrow waves-effect waves-dark" href="javascript:void(0)" aria-expanded="false">
                                                <i class="fa-solid fa-money-bill"></i>
                                                <span class="hide-menu">Deposit</span>
                                            </a>
                                            <ul aria-expanded="false" class="collapse first-level">
                                                <li class="sidebar-item">
                                                    <a href="?page=permintaan_deposit" class="sidebar-link">
                                                        <i class="fa-brands fa-react"></i>
                                                        <span class="hide-menu">Permintaan Deposit</span>
                                                    </a>
                                                </li>
                                                <li class="sidebar-item">
                                                    <a href="?page=daftar_deposit" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Daftar Deposit</span>
                                                    </a></li>
                                                </ul>
                                            </li>
                                            <li class="sidebar-item"> 
                                                <a class="sidebar-link has-arrow waves-effect waves-dark" href="javascript:void(0)" aria-expanded="false">
                                                    <i class="fa-solid fa-coins"></i>
                                                    <span class="hide-menu">Withdraw</span>
                                                </a>
                                                <ul aria-expanded="false" class="collapse first-level">
                                                    <li class="sidebar-item">
                                                        <a href="?page=permintaan_withdraw" class="sidebar-link">
                                                            <i class="fa-brands fa-react"></i>
                                                            <span class="hide-menu">Permintaan Withdraw</span>
                                                        </a>
                                                    </li>
                                                    <li class="sidebar-item">
                                                        <a href="?page=daftar_withdraw" class="sidebar-link">
                                                            <i class="fa-brands fa-react"></i>
                                                            <span class="hide-menu">Daftar Withdraw</span>
                                                        </a>
                                                    </li>
                                                    </ul>
                                                </li>
                                                <li class="sidebar-item"> 
                                                    <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=riwayatmember" aria-expanded="false">
                                                        <i class="fa-solid fa-clock-rotate-left"></i>
                                                        <span class="hide-menu">Riwayat Member</span>
                                                    </a>
                                                </li>
                                                <?php
                                                if ($c['level'] == "superadmin") {
                                                    ?>
                                                    <li class="sidebar-item"> 
                                                        <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=bonus" aria-expanded="false">
                                                            <i class="fa-solid fa-trophy"></i>
                                                            <span class="hide-menu">Bonus</span>
                                                        </a>
                                                    </li>
                                                    <?php
                                                }
                                                ?>

                                                <li class="sidebar-item"> 
                                                    <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=saldo_member" aria-expanded="false">
                                                        <i class="fa-solid fa-database"></i>
                                                        <span class="hide-menu">Saldo member</span>
                                                    </a>
                                                </li>
                                                <?php
                                                if ($c['level'] == "superadmin") {
                                                    ?>
                                                    <li class="nav-small-cap">
                                                        <i class="mdi mdi-dots-horizontal"></i>
                                                        <span class="hide-menu">Sistem</span>
                                                    </li>
                                                    <li class="sidebar-item"> 
                                                        <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=bank" aria-expanded="false">
                                                        <i class="fa-solid fa-credit-card"></i>
                                                            <span class="hide-menu">Rekening Deposit</span>
                                                        </a>
                                                    </li>
                                                    <li class="sidebar-item"> 
                                                        <a class="sidebar-link waves-effect waves-dark sidebar-link" href="?page=depowd" aria-expanded="false">
                                                        <i class="fa-solid fa-rupiah-sign"></i>
                                                            <span class="hide-menu">Minimal Depo & Wd</span>
                                                        </a>
                                                    </li>
                                                    <?php
                                                }
                                                ?>
                                                <li class="sidebar-item"> <a class="sidebar-link has-arrow waves-effect waves-dark" href="javascript:void(0)" aria-expanded="false"><i class="fa-solid fa-user"></i><span class="hide-menu">Member</span></a>
                                                    <ul aria-expanded="false" class="collapse first-level">
                                                        <li class="sidebar-item"><a href="?page=user" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">User</span></a></li>
                                                        <?php
                                                        if ($c['level'] == "superadmin") {
                                                            ?>
                                                            <li class="sidebar-item"><a href="?page=administrator" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Administrator</span></a></li>
                                                            <?php
                                                        }
                                                        ?>

                                                        
                                                    </ul>
                                                </li>
                                                <?php
                                                if ($c['level'] == "superadmin") {
                                                    ?>
                                                    <li class="sidebar-item"> <a class="sidebar-link has-arrow waves-effect waves-dark" href="javascript:void(0)" aria-expanded="false"><i class="fa-solid fa-gears"></i><span class="hide-menu">Setting</span></a>
                                                    <ul aria-expanded="false" class="collapse first-level">    

                                                        <li class="sidebar-item"><a href="?page=banner" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Banner</span></a></li>
                                                        
                                                        <li class="sidebar-item"><a href="?page=bannerdesk" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Banner Desktop</span></a></li>

                                                        <li class="sidebar-item"><a href="?page=website" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Seo Website & Logo</span></a></li>

                                                        <li class="sidebar-item"><a href="?page=popup" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Popup</span></a></li>

                                                        <li class="sidebar-item"><a href="?page=contact" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Live Chat & Whatsapp</span></a></li>

                                                         <li class="sidebar-item"><a href="?page=warna" class="sidebar-link"><i class="fa-brands fa-react"></i><span class="hide-menu">Warna Website</span></a></li>
                                                    </ul>
                                                </li>

                                                    <?php
                                                }
                                                ?>


                                                
                                            </ul>
                                        </nav>
                                    </div>
                                </aside>

                                <div class="page-wrapper">
                                    <?php
                                        $sql = "SELECT * FROM tb_transaksi WHERE status = ? AND transaksi = ? ORDER BY id DESC LIMIT 1";
                                        $stmt = $koneksi->prepare($sql);
                                        $status = 'Pending';
                                        $transaksi = 'Top Up';
                                        $stmt->bind_param("ss", $status, $transaksi);
                                        $stmt->execute();
                                        $result = $stmt->get_result();
                                        
                                        while ($data = $result->fetch_assoc()) {
                                            $id_user = $data['id_user'];
                                        
                                            $sql_user = "SELECT * FROM tb_user WHERE extplayer = ?";
                                            $stmt_user = $koneksi->prepare($sql_user);
                                            $stmt_user->bind_param("s", $id_user);
                                            $stmt_user->execute();
                                            $result_user = $stmt_user->get_result();
                                            $liat_user = $result_user->fetch_assoc();
                                            
                                            if (empty($liat_user['username'])) {
                                            continue;
                                            }
                                            if ($data['transaksi'] == "Top Up") {
                                            ?>
                                            <div class="alert alert-success"> 
                                                <i class="ti-user"></i>  
                                                <?php echo  $liat_user['username']; ?> Melakukan Top Up Saldo Senilai Rp. <?php echo number_format($data['total']); ?> <a href="?page=permintaan_deposit">Klik Disini</a> Untuk Konfirmasi
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
                                            </div>
                                            <?php
                                        }
                                        $stmt_user->close();
                                    }
                                    $stmt->close();
                                    ?>

                                    <?php
                                        $sql = "SELECT * FROM tb_transaksi WHERE status = ? AND transaksi = ? ORDER BY id DESC LIMIT 1";
                                        $stmt = $koneksi->prepare($sql);
                                        $status = 'Pending';
                                        $transaksi = 'Withdraw';
                                        $stmt->bind_param("ss", $status, $transaksi);
                                        $stmt->execute();
                                        $result = $stmt->get_result();
                                        
                                        while ($data = $result->fetch_assoc()) {
                                            $id_user = $data['id_user'];
                                        
                                            $sql_user = "SELECT * FROM tb_user WHERE extplayer = ?";
                                            $stmt_user = $koneksi->prepare($sql_user);
                                            $stmt_user->bind_param("s", $id_user);
                                            $stmt_user->execute();
                                            $result_user = $stmt_user->get_result();
                                            $liat_user = $result_user->fetch_assoc();

                                        if ($data['transaksi'] == 'Withdraw') {
                                            ?>
                                            <div class="alert alert-danger"> 
                                                <i class="ti-user"></i>  
                                                <?php echo  $liat_user['username']; ?> Melakukan Penarikan Saldo Senilai Rp. <?php echo number_format($data['total']); ?> <a href="?page=permintaan_withdraw">Klik Disini</a> Untuk Konfirmasi
                                                <button type="button" class="close" data-dismiss="alert" aria-label="Close"> <span aria-hidden="true">&times;</span> </button>
                                            </div>
                                            <?php
                                        }
                                        $stmt_user->close();

                                    }
                                    $stmt->close();
                                    ?>

                                    <?php
                                    
                                $pages =
                                [
                                    "dashboard" => 'page/dashboard/dashboard.php',
                                    "bank" => 'page/bank/bank.php',
                                    "banner" => 'page/banner/banner.php',
                                    //"history" => 'page/game/history.php',
                                    "mtgame" => 'page/game/mtgame.php',
                                    "tambah_banner" => 'page/banner/tambah_banner.php',
                                    "hapus_banner" => 'page/banner/hapus_banner.php',
                                    "edit_banner" => 'page/banner/edit_banner.php',
                                    "proses_edit_banner" => 'page/banner/proses_edit_banner.php',
                                    //
                                    "bannerdesk" => 'page/bannerdesk/bannerdesk.php',
                                    "tambah_bannerdesk" => 'page/bannerdesk/tambah_bannerdesk.php',
                                    "hapus_bannerdesk" => 'page/bannerdesk/hapus_bannerdesk.php',
                                    "edit_bannerdesk" => 'page/bannerdesk/edit_bannerdesk.php',
                                    "proses_edit_bannerdesk" => 'page/bannerdesk/proses_edit_bannerdesk.php',
                                    //
                                    "user" => 'page/user/user.php',
                                    "lihat_profil" => 'page/user/lihat_profil.php',
                                    "update_user" => 'page/user/update_user.php',
                                    "suspend_member" => 'page/user/suspend_member.php',
                                    "active_member" => 'page/user/active_member.php',
                                    "ongame" => 'page/user/ongame.php',
                                    "offgame" => 'page/user/offgame.php',
                                    "hapus_user" => 'page/user/hapus.php',
                                    "admin" => 'page/admin/admin.php',
                                    "update_admin" => 'page/admin/update_admin.php',
                                    "administrator" => 'page/administrator/administrator.php',
                                    "update_administrator" => 'page/administrator/update_administrator.php',
                                    "tambah_administrator" => 'page/administrator/tambah_administrator.php',
                                    "proses_tambah_admin" => 'page/administrator/proses_tambah_admin.php',
                                    "hapus_administrator" => 'page/administrator/hapus_administrator.php',
                                    "edit_administrator" => 'page/administrator/edit_administrator.php',
                                    //berita
                                    "news" => 'page/news/berita.php',
                                    "tambah_berita" => 'page/news/tambah_berita.php',
                                    "proses_tambah_berita" => 'page/news/proses_tambah_berita.php',
                                    "edit_berita" => 'page/news/edit_berita.php',
                                    "proses_edit_berita" => 'page/news/proses_edit_berita.php',
                                    "hapus_berita" => 'page/news/hapus_berita.php',
                                    //end berita
                                    "promosi" => 'page/promosi/promosi.php',
                                    "tambah_promosi" => 'page/promosi/tambah_promosi.php',
                                    "proses_tambah_promosi" => 'page/promosi/proses_tambah_promosi.php',
                                    "edit_promosi" => 'page/promosi/edit_promosi.php',
                                    "proses_edit_promosi" => 'page/promosi/proses_edit_promosi.php',
                                    "hapus_promosi" => 'page/promosi/hapus_promosi.php',
                                    //
                                    "permintaan_deposit" => 'page/deposit/permintaan_deposit.php',
                                    "bonus" => 'page/bonus/bonus.php',
                                    "batalkan_bonus" => 'page/bonus/batalkan_bonus.php',
                                    "website" => 'page/website/website.php',
                                    "edit_website" => 'page/website/edit_website.php',
                                    "popup" => 'page/popup/popup.php',
                                    "edit_popup" => 'page/popup/edit_popup.php',
                                    "permintaan_withdraw" => 'page/withdraw/permintaan_withdraw.php',
                                    "proses_withdraw" => 'page/withdraw/proses_withdraw.php',
                                    "daftar_withdraw" => 'page/withdraw/daftar_withdraw.php',
                                    "proses_batal_withdraw" => 'page/withdraw/proses_batal_withdraw.php',
                                    "daftar_deposit" => 'page/deposit/daftar_deposit.php',
                                    "proses_deposit" => 'page/deposit/proses_deposit.php',
                                    "proses_depositmas" => 'page/deposit/proses_mass_deposit.php',
                                    "proses_batal_deposit" => 'page/deposit/proses_batal_deposit.php',
                                    "tambah_bank" => 'page/bank/tambah_bank.php',
                                    "hapus_bank" => 'page/bank/hapus_bank.php',
                                    "edit_bank" => 'page/bank/edit_bank.php',
                                    "proses_edit_bank" => 'page/bank/proses_edit_bank.php',
                                    "saldo_member" => 'page/saldo_member/saldo_member.php',
                                    "tambah_saldo" => 'page/saldo_member/tambah_saldo.php',
                                    "contact" => 'page/contact/contact.php',
                                    "update_contact" => 'page/contact/update_contact.php',
                                    "depowd" => 'page/depowd/depowd.php',
                                    "update_depowd" => 'page/depowd/update_depowd.php',
                                    "warna" => 'page/warna/warna.php',
                                    "update_warna" => 'page/warna/update_warna.php',
                                    "riwayatmember" => 'page/member/riwayat.php'
                                ];
                            
                                $page = filter_input(INPUT_GET, 'page', FILTER_DEFAULT);
                                $page = !empty($page) ? htmlspecialchars($page, ENT_QUOTES, 'UTF-8') : '';


                            if (!$page || !preg_match('/^[a-zA-Z0-9_]+$/', $page)) {
                                $page = 'dashboard';
                            }
                            
                            if (array_key_exists($page, $pages)) {
                                include $pages[$page];
                            } else {
                                include 'page/dashboard/dashboard.php';
                            }
                            ?>
                        </div>
                    </div>
                    <script src="../assets/libs/jquery/dist/jquery.min.js"></script>
                    <script src="../assets/libs/popper.js/dist/umd/popper.min.js"></script>
                    <script src="../assets/libs/bootstrap/dist/js/bootstrap.min.js"></script>
                    <!-- apps -->
                    <script src="../dist/js/app.min.js"></script>
                    <script src="../dist/js/app.init.js"></script>
                    <script src="../dist/js/app-style-switcher.js"></script>
                    <!-- slimscrollbar scrollbar JavaScript -->
                    <script src="../assets/libs/perfect-scrollbar/dist/perfect-scrollbar.jquery.min.js"></script>
                    <script src="../assets/extra-libs/sparkline/sparkline.js"></script>
                    <!--Wave Effects -->
                    <script src="../dist/js/waves.js"></script>
                    <!--Menu sidebar -->
                    <script src="../dist/js/sidebarmenu.js"></script>
                    <!--Custom JavaScript -->
                    <script src="../dist/js/custom.min.js"></script>
                    <script src="../assets/libs/toastr/build/toastr.min.js"></script>
                    <script src="../assets/extra-libs/toastr/toastr-init.js"></script>
                    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
                    <script src="../assets/libs/select2/dist/js/select2.full.min.js"></script>
                    <script src="../assets/libs/select2/dist/js/select2.min.js"></script>
                    <script src="../dist/js/pages/forms/select2/select2.init.js"></script>
                    <script src="../assets/libs/sweetalert2/dist/sweetalert2.all.min.js"></script>
                    <script src="../assets/extra-libs/DataTables/datatables.min.js"></script>
                    <script src="../dist/js/pages/datatable/datatable-basic.init.js"></script>
                </body>

                </html>