<?php
if ($c['level'] == "superadmin") {
    ?>

    <div class="page-breadcrumb">
        <div class="row">
            <div class="col-5 align-self-center">
                <h4 class="page-title">Transaksi</h4>
            </div>
            <div class="col-7 align-self-center">
                <div class="d-flex align-items-center justify-content-end">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item">
                                <a href="#">Transaksi</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Rekening Deposit</li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <!-- Bagian Input Data Rekening dan Pengaturan QRIS -->
            <div class="col-lg-4 mb-4">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Input Data Rekening</h4>
                        <form class="form p-t-20" method="POST" action="?page=tambah_bank" enctype="multipart/form-data">
                            <div class="form-group">
                                <label>Icon Bank</label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon11"><i class="ti-user"></i></span>
                                    </div>
                                    <input type="file" class="form-control" required="" name="file">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nama Bank</label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon11"><i class="ti-user"></i></span>
                                    </div>
                                    <input type="text" name="nama_bank" class="form-control" placeholder="Nama Bank" required="" aria-label="Username" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nomor Rekening</label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon11"><i class="ti-user"></i></span>
                                    </div>
                                    <input type="number" name="nomor_rekening" class="form-control" placeholder="Nomor Rekening" required="" aria-label="Username" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Nama Pemilik Rekening</label>
                                <div class="input-group mb-3">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text" id="basic-addon11"><i class="ti-user"></i></span>
                                    </div>
                                    <input type="text" name="nama_pemilik" class="form-control" placeholder="Nama Pemilik Rekening" required="" aria-label="Username" aria-describedby="basic-addon11">
                                </div>
                            </div>
                            <button type="submit" name="upload" class="btn btn-success m-r-10">Submit</button>
                            <button type="reset" class="btn btn-dark">Cancel</button>
                        </form>

                        <hr>
                        <h4 class="card-title">Pengaturan Payment Gateway</h4>
                        <form class="form p-t-20" method="POST" action="">
                            <?php
                            // Proses form jika ada submit
                            if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_qris'])) {
                                $newStatus = $_POST['status'];
                                $apikey = $_POST['apikey'];
                                $apiid = $_POST['apiid'];
                                $signature = $_POST['signature'];

                                $sql = "UPDATE qris_status SET status = '$newStatus', apikey = '$apikey', apiid = '$apiid', signature = '$signature' WHERE id = 1";
                                if (mysqli_query($koneksi, $sql)) {
                                    echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                                    echo "<script>
                                            Swal.fire({
                                                title: 'Success!',
                                                text: 'Pengaturan Payment berhasil diperbarui.',
                                                icon: 'success',
                                                confirmButtonText: 'OK'
                                            });
                                          </script>";
                                } else {
                                    echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                                    echo "<script>
                                            Swal.fire({
                                                title: 'Error!',
                                                text: 'Terjadi kesalahan saat memperbarui pengaturan.',
                                                icon: 'error',
                                                confirmButtonText: 'OK'
                                            });
                                          </script>";
                                }
                            }

                            // Query untuk mendapatkan status QRIS saat ini
                            $sql = "SELECT status, apikey, apiid, signature FROM qris_status WHERE id = 1";
                            $result = mysqli_query($koneksi, $sql);
                            $currentStatus = 'offline';
                            $currentApikey = '';
                            $currentApiid = '';
                            $currentSignature = '';

                            if (mysqli_num_rows($result) > 0) {
                                $row = mysqli_fetch_assoc($result);
                                $currentStatus = $row['status'];
                                $currentApikey = $row['apikey'];
                                $currentApiid = $row['apiid'];
                                $currentSignature = $row['signature'];
                            }
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['update_payment_status'])) {
                $paymentCode = $_POST['payment_code'];
                $paymentStatus = $_POST['payment_status'];

                $sql = "UPDATE payment_methods SET payment_status = '$paymentStatus' WHERE payment_code = '$paymentCode'";
                if (mysqli_query($koneksi, $sql)) {
                    echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                    echo "<script>
                            Swal.fire({
                                title: 'Success!',
                                text: 'Status Pembayaran berhasil diperbarui.',
                                icon: 'success',
                                confirmButtonText: 'OK'
                            });
                          </script>";
                } else {
                    echo '<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>';
                    echo "<script>
                            Swal.fire({
                                title: 'Error!',
                                text: 'Terjadi kesalahan saat memperbarui status pembayaran.',
                                icon: 'error',
                                confirmButtonText: 'OK'
                            });
                          </script>";
                }
            }

            // Query untuk mendapatkan semua opsi pembayaran
            $sqlPayments = "SELECT payment_code, payment_name, payment_status FROM payment_methods";
            $resultPayments = mysqli_query($koneksi, $sqlPayments);
            ?>
                            <div class="form-group">
                                <label for="status">PG Status</label>
                                <select name="status" id="status" class="form-control">
                                    <option value="online" <?php if ($currentStatus == 'online') echo 'selected'; ?>>Online</option>
                                    <option value="offline" <?php if ($currentStatus == 'offline') echo 'selected'; ?>>Offline</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="apikey">API Key</label>
                                <input type="text" name="apikey" id="apikey" class="form-control" value="<?php echo $currentApikey; ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="apiid">API ID</label>
                                <input type="text" name="apiid" id="apiid" class="form-control" value="<?php echo $currentApiid; ?>" required>
                            </div>
                            <div class="form-group">
                                <label for="signature">Signature</label>
                                <input type="text" name="signature" id="signature" class="form-control" value="<?php echo $currentSignature; ?>" required>
                            </div>
                            <button type="submit" name="update_qris" class="btn btn-success m-r-10">Update Pengaturan</button>
                            <button type="button" class="btn btn-dark" data-toggle="modal" data-target="#statusModal">Setting Status</button>
                        </form>
                    </div>
                </div>
            </div>
                                    <div id="statusModal" class="modal fade" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">Setting Status Pembayaran</h5>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <form id="statusForm" method="POST" action="">
                                            <div class="form-group">
                                                <label for="payment_name">Payment Name</label>
 <select name="payment_code" id="payment_code" class="form-control" required>
                                    <?php
                                    while ($rowPayment = mysqli_fetch_assoc($resultPayments)) {
                                        $paymentCode = htmlspecialchars($rowPayment['payment_code']);
                                        $paymentName = htmlspecialchars($rowPayment['payment_name']);
                                        $paymentStatus = htmlspecialchars($rowPayment['payment_status']);
                                        echo "<option value=\"$paymentCode\" data-status=\"$paymentStatus\">$paymentName</option>";
                                    }
                                    ?>
                                </select>
                                            </div>
                            <div class="form-group">
                                <label for="payment_status">Status Pembayaran</label>
                                <select name="payment_status" id="payment_status" class="form-control" required>
                                    <?php
                                    $selectedPaymentStatus = ''; // Variabel ini akan diisi dengan status pembayaran saat ini dari database
                                    if (isset($_POST['payment_code'])) {
                                        // Ambil payment_status dari database berdasarkan payment_code yang dipilih
                                        $selectedPaymentCode = $_POST['payment_code'];
                                        $sqlPaymentStatus = "SELECT payment_status FROM payment_methods WHERE payment_code = '$selectedPaymentCode'";
                                        $resultPaymentStatus = mysqli_query($koneksi, $sqlPaymentStatus);
                                        if (mysqli_num_rows($resultPaymentStatus) > 0) {
                                            $rowPaymentStatus = mysqli_fetch_assoc($resultPaymentStatus);
                                            $selectedPaymentStatus = $rowPaymentStatus['payment_status'];
                                        }
                                    }
                                    ?>
                                    <option value="ON" <?php echo ($selectedPaymentStatus == 'ON') ? 'selected' : ''; ?>>ON</option>
                                    <option value="OFF" <?php echo ($selectedPaymentStatus == 'OFF') ? 'selected' : ''; ?>>OFF</option>
                                </select>
                            </div>
                                            <div class="form-group text-center">
                                                <button type="submit" name="update_payment_status" class="btn btn-primary">Update Status</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
            <!-- Daftar Rekening Bank -->
            <div class="col-lg-8 mb-4">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Daftar Rekening Bank</h4>
                    </div>
                    <div class="table-responsive">
                        <table id="zero_config" class="table table-striped table-bordered ">
                            <thead>
                                <tr>
                                    <th scope="col">#</th>
                                    <th scope="col">Nama Bank</th>
                                    <th scope="col">Nomor Rekening</th>
                                    <th scope="col">Nama Pemilik Rekening</th>
                                    <th scope="col">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin' ");
                                $no = 1;
                                while ($data = mysqli_fetch_array($query)) {
                                    ?>
                                    <tr>
                                        <th scope="row"><?php echo $no++; ?></th>
                                        <td><?php echo $data['nama_bank']; ?></td>
                                        <td><?php echo $data['nomor_rekening']; ?></td>
                                        <td><?php echo $data['nama_pemilik']; ?></td>
                                        <td>
                                            <a href="?page=edit_bank&id=<?php echo $data['id'] ?>" class="btn btn-small btn-primary">Edit</a>
                                            <a href="?page=hapus_bank&id=<?php echo $data['id'] ?>" class="btn btn-small btn-danger">Hapus</a>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
        <?php
    } else {
        ?>
        <script type="text/javascript">
            window.location = "?page=dashboard";
        </script>
        <?php
    }
?>