<?php
include '../../function/connect.php';
?>
<div class="page-breadcrumb">
    <div class="row">
        <div class="col-5 align-self-center">
            <h4 class="page-title">Dashboard Page</h4>
        </div>
        <div class="col-7 align-self-center">
            <div class="d-flex align-items-center justify-content-end">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="#">Home</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="card-group">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex no-block align-items-center">
                            <div>
                                <i class="mdi mdi-emoticon font-20 text-muted"></i>
                                <p class="font-16 m-b-5">Jumlah Member</p>
                            </div>
                            <div class="ml-auto">
                                <?php 
                                $query = mysqli_query($koneksi, "SELECT * FROM tb_user WHERE status = 'active' ");
                                $hitung_user = mysqli_num_rows($query);
                                ?>
                                <h1 class="font-light text-right"><?php echo number_format($hitung_user); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex no-block align-items-center">
                            <div>
                                <i class="mdi mdi-checkbox-marked-circle font-20 text-muted"></i>
                                <p class="font-16 m-b-5">Total Approved</p>
                                <?php 
                                $today = date('Y-m-d');
                                $query1 = mysqli_query($koneksi, "SELECT COUNT(*) as total_approved FROM tb_transaksi 
                                                                WHERE status IN ('Sukses', 'SUCCESS') 
                                                                AND DATE(tanggal) = '$today'");
                                $row = mysqli_fetch_assoc($query1);
                                $total_approved = $row['total_approved'];
                                ?>
                            </div>
                            <div class="ml-auto">
                                <h1 class="font-light text-right"><?php echo number_format($total_approved); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex no-block align-items-center">
                            <div>
                                <i class="mdi mdi-close-outline font-20 text-muted"></i>
                                <p class="font-16 m-b-5">Total Rejected</p>
                                <?php 
                                $today = date('Y-m-d');
                                $query1 = mysqli_query($koneksi, "SELECT COUNT(*) as total_rejected FROM tb_transaksi WHERE status IN ('Ditolak', 'NO_PAY') AND DATE(tanggal) = '$today'");
                                $row = mysqli_fetch_assoc($query1);
                                $total_rejected = $row['total_rejected'];
                                ?>
                            </div>
                            <div class="ml-auto">
                                <h1 class="font-light text-right"><?php echo number_format($total_rejected); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column -->
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="d-flex no-block align-items-center">
                            <div>
                                <i class="mdi mdi-poll font-20 text-muted"></i>
                                <p class="font-16 m-b-5">Total Daftar Hari ini</p>
                            </div>
                            <div class="ml-auto">
                                <?php 
                                $tanggal_hari_ini = date('Y-m-d');
                                $query3 = mysqli_query($koneksi, "SELECT COUNT(*) as jumlah_daftar_hari_ini FROM tb_user WHERE DATE(created_at) = '$tanggal_hari_ini'");
                                $row = mysqli_fetch_assoc($query3);
                                $jumlah_daftar_hari_ini = $row['jumlah_daftar_hari_ini'];
                                ?>
                                <h1 class="font-light text-right"><?php echo number_format($jumlah_daftar_hari_ini); ?></h1>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-md-12">
                    <div class="d-flex no-block align-items-center">
                        <div>
                            <i class="mdi mdi-currency-usd font-20 text-muted"></i>
                            <p class="font-16 m-b-5">Jumlah Balance Agent</p>
                        </div>
                        <div class="ml-auto">
                            <?php
                            // Ambil konfigurasi dari tabel config
                            $sql_config = "SELECT url_request, agent_code, signature FROM config WHERE id = 1";
                            $result_config = mysqli_query($koneksi, $sql_config);
                            if (mysqli_num_rows($result_config) == 0) {
                                echo "<h1 class='font-light text-right' style='color: red;'>Error: Konfigurasi tidak ditemukan</h1>";
                            } else {
                                $config = mysqli_fetch_assoc($result_config);
                                $url_request = $config['url_request'];
                                $agent_code = $config['agent_code'];
                                $signature = $config['signature'];

                                // Buat payload untuk SGX API (agent_info)
                                $postArray = [
                                    'command' => 'agent_info',
                                    'agent_code' => $agent_code,
                                    'signature' => $signature
                                ];
                                $jsonData = json_encode($postArray);
                                $headerArray = ['Content-Type: application/json'];

                                // Kirim permintaan ke SGX API
                                $ch = curl_init();
                                curl_setopt($ch, CURLOPT_URL, $url_request);
                                curl_setopt($ch, CURLOPT_POST, 1);
                                curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
                                curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
                                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                                curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
                                $output = curl_exec($ch);
                                curl_close($ch);

                                // Parse respon dari SGX API
                                $data = json_decode($output, true);

                                // Tulis response ke log server untuk debugging
                                error_log("Agent Info Response: " . $output);

                                if (isset($data['status']) && $data['status'] == 200 && isset($data['data']['balance'])) {
                                    $balance = number_format($data['data']['balance']);
                                    echo "<h1 class='font-light text-right' style='color: #137eff!important;'>{$balance}</h1>";
                                } else {
                                    $errorMsg = isset($data['message']) ? $data['message'] : "Gagal mengambil saldo agen";
                                    echo "<h1 class='font-light text-right' style='color: red;'>Error: {$errorMsg}</h1>";
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body bg-light">
                <div class="row align-items-center">
                    <div class="col-xs-12 col-md-6">
                        <h3 class="m-b-0 font-light">Data Deposit Hari Ini</h3>
                        <span class="font-14 text-muted">Total Deposit</span>
                    </div>
                    <?php 
                    $tanggal_sekarang = date("Y-m-d");
                    $total_pendapatan = 0;
                    $sql = mysqli_query($koneksi, "SELECT * FROM tb_transaksi 
                                                   WHERE DATE(tanggal) = '$tanggal_sekarang' 
                                                   AND transaksi = 'Top Up' 
                                                   AND status IN ('Sukses', 'SUCCESS')");
                    $result = mysqli_num_rows($sql);
                    if ($result > 0) {
                        while ($row = mysqli_fetch_array($sql)) {
                            $total_pendapatan += $row["total"];
                        }
                    }
                    ?>
                    <div class="col-xs-12 col-md-6 align-self-center display-6 text-info text-right">Rp. <?php echo number_format($total_pendapatan); ?></div>
                </div>
            </div>
            <div class="table-responsive">
                <table id="zero_config" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th class="border-top-0">Tanggal</th>
                            <th class="border-top-0">Status</th>
                            <th class="border-top-0">Total</th>
                            <th class="border-top-0">Pembayaran Ke</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $total_pendapatan = 0;
                        $sql = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE DATE(tanggal) = '$tanggal_sekarang' AND transaksi = 'Top Up' AND status IN ('Sukses', 'SUCCESS')");
                        $result = mysqli_num_rows($sql);
                        if ($result > 0) {
                            while ($row = mysqli_fetch_array($sql)) {
                                echo "<tr>";
                                echo "<td class='txt-oflo'>" . $row["tanggal"] . "</td>";
                                echo "<td><span class='label label-success label-rounded'>" . $row["status"] . "</span></td>";
                                echo "<td class='txt-oflo'>Rp. " . number_format($row["total"]) . "</td>";
                                echo "<td><span class='font-medium'>" . $row["metode"] . "</span></td>";
                                echo "</tr>";
                                $total_pendapatan += $row["total"];
                            }
                        } else {
                            echo "<tr><td colspan='4' class='text-center'>Tidak ada data transaksi untuk hari ini.</td></tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>