<div class="page-breadcrumb">
    <div class="row">
        <div class="col-5 align-self-center">
            <h4 class="page-title">Permintaan Deposit</h4>
        </div>
        <div class="col-7 align-self-center">
            <div class="d-flex align-items-center justify-content-end">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="#">Daftar Permintaan Deposit</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Menu Permintaan Deposit</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Daftar Permintaan Deposit</h4>
                </div>
                <form action="?page=proses_mass_deposit" method="post">
                    <div class="table-responsive">
                        <table id="zero_config" class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th scope="col">
                                        <input type="checkbox" id="select-all">
                                    </th>
                                    <th scope="col">Tanggal</th>
                                    <th scope="col">Username</th>
                                    <th scope="col">Metode Pembayaran</th>
                                    <th scope="col">Pembayaran Dari</th>
                                    <th scope="col">Nomor Rekening</th>
                                    <th scope="col">Nama Pemilik</th>
                                    <th scope="col">Bonus</th>
                                    <th scope="col">Jumlah</th>
                                    <th scope="col">Bukti</th>
                                    <th scope="col">Keterangan</th>
                                    <th scope="col">RDP</th>
                                    <th scope="col">Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE status = 'Pending' AND transaksi = 'Top Up'");
                                $no = 1;
                                while ($data = mysqli_fetch_array($query)) {
                                    $id_user = $data['id_user'];
                                    $bonus = $data['bonus'];
                                    $keterangan = $data['keterangan'];
                                    $query1 = mysqli_query($koneksi, "SELECT * FROM tb_user WHERE extplayer = '$id_user'");
                                    $d = mysqli_fetch_array($query1);
                                    if (empty($d['username'])) {
                                    continue;
                                    }
                                    $query2 = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id_user = '$id_user'");
                                    $e = mysqli_fetch_array($query2);
                                    $dari_bank_id = $data['dari_bank'];
                                    $query3 = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id = '$dari_bank_id'");
                                    $f = mysqli_fetch_array($query3);

                                    // Cek apakah transaksi ini adalah deposit pertama kali
                                    $first_deposit_query = mysqli_query($koneksi, "SELECT MIN(id) as first_deposit_id FROM tb_transaksi WHERE transaksi = 'Top Up' AND id_user = '$id_user'");
                                    $first_deposit_data = mysqli_fetch_array($first_deposit_query);
                                    $is_first_deposit = ($data['id'] == $first_deposit_data['first_deposit_id']) ? 'Ya' : 'Tidak';
                                    ?>
                                    <tr>
                                        <td>
                                            <input type="checkbox" name="selected_ids[]" value="<?php echo $data['id']; ?>">
                                        </td>
                                        <td><?php echo htmlspecialchars($data['tanggal']); ?></td>
                                        <td><?php echo htmlspecialchars($d['username']); ?></td>
                                        <td><?php echo htmlspecialchars($data['metode']); ?></td>
                                        <td><?php echo htmlspecialchars($f['nama_bank']); ?></td>
                                        <td><?php echo htmlspecialchars($f['nomor_rekening']); ?></td>
                                        <td><?php echo htmlspecialchars($e['nama_pemilik']); ?></td>
                                        <td><?php echo htmlspecialchars($data['bonus']); ?></td>
                                        <td>Rp. <?php echo number_format($data['total']); ?></td>
                                        <td>
                                            <a href="../../upload/bukti_transfer/<?php echo htmlspecialchars($data['gambar']); ?>" class="btn btn-success" target="_blank">Bukti Transfer</a>
                                        </td>
                                        <td><?php echo htmlspecialchars($is_first_deposit); ?></td>
                                        <td><?php echo htmlspecialchars($keterangan); ?></td>
                                        <td>
                                            <a href="?page=proses_deposit&id=<?php echo htmlspecialchars($data['id']); ?>" class="btn btn-primary">Proses</a>
                                            <a href="?page=proses_batal_deposit&id=<?php echo htmlspecialchars($data['id']); ?>" class="btn btn-danger">Reject</a>
                                        </td>
                                    </tr>
                                    <?php
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                    <button type="submit" name="proses_selected" class="btn btn-primary">Proses yang Dipilih</button>
                    <button type="submit" name="tolak_selected" class="btn btn-danger">Tolak yang Dipilih</button>
                    <button type="submit" name="suspend_selected" class="btn btn-warning">Suspend yang Dipilih</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    document.getElementById('select-all').onclick = function() {
        var checkboxes = document.querySelectorAll('input[type="checkbox"]');
        for (var checkbox of checkboxes) {
            checkbox.checked = this.checked;
        }
    }
</script>
