<?php
include '../../function/connect.php';

if (isset($_POST['selected_ids'])) {
    $selected_ids = $_POST['selected_ids'];
    $tanggal = date('Y-m-d H:i:s');

    // Ambil konfigurasi dari tabel config
    $sql_config = "SELECT url_request, agent_code, signature FROM config WHERE id = 1";
    $result_config = mysqli_query($koneksi, $sql_config);
    if (mysqli_num_rows($result_config) == 0) {
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak ditemukan.",
                icon: "error",
                confirmButtonText: "Ok",
            }).then(function() {
                window.location = "?page=permintaan_deposit";
            });
        </script>
        <?php
        exit();
    }
    $config = mysqli_fetch_assoc($result_config);
    $url_request = $config['url_request'];
    $agent_code = $config['agent_code'];
    $signature = $config['signature'];

    foreach ($selected_ids as $id) {
        $id = mysqli_real_escape_string($koneksi, $id);
        $query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE id = '$id'");
        $data = mysqli_fetch_array($query);

        if ($data) { // Memastikan data ditemukan
            $id_user = $data['id_user'];
            $total = (int)$data['total'];

            // Proses deposit untuk user
            $postArray = [
                'command' => 'user_deposit',
                'agent_code' => $agent_code,
                'signature' => $signature,
                'user_code' => $id_user,
                'amount' => $total
            ];
            $jsonData = json_encode($postArray);
            $headerArray = ['Content-Type: application/json'];

            // Kirim permintaan ke SGX API untuk deposit user
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url_request);
            curl_setopt($ch, CURLOPT_POST, 1);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
            curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
            $output = curl_exec($ch);
            curl_close($ch);

            // Parse respon dari SGX API untuk deposit user
            $Transaksi = json_decode($output, true);

            if (isset($Transaksi['status']) && $Transaksi['status'] == 200 && $Transaksi['message'] == 'SUCCESS') {
                // Proses bonus referral jika ada
                $persen = $total * 0.1;
                $cek_reff = mysqli_query($koneksi, "SELECT * FROM tb_refferal WHERE id_user = '$id_user'");
                $liat = mysqli_fetch_array($cek_reff);
                $reff = $liat['user_refferal'];
                $hitung_reff = mysqli_num_rows($cek_reff);

                if ($hitung_reff > 0) {
                    // Proses deposit untuk referral
                    $postArrayReff = [
                        'command' => 'user_deposit',
                        'agent_code' => $agent_code,
                        'signature' => $signature,
                        'user_code' => $reff,
                        'amount' => (int)$persen
                    ];
                    $jsonDataReff = json_encode($postArrayReff);

                    // Kirim permintaan ke SGX API untuk deposit referral
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $url_request);
                    curl_setopt($ch, CURLOPT_POST, 1);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonDataReff);
                    curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
                    $outputReff = curl_exec($ch);
                    curl_close($ch);

                    // Parse respon dari SGX API untuk deposit referral
                    $TransaksiReff = json_decode($outputReff, true);

                    if (isset($TransaksiReff['status']) && $TransaksiReff['status'] == 200 && $TransaksiReff['message'] == 'SUCCESS') {
                        mysqli_query($koneksi, "UPDATE tb_refferal SET bonus = '1' WHERE id_user = '$id_user'");
                        mysqli_query($koneksi, "UPDATE tb_saldo SET active = active + $persen WHERE id_user = '$reff'");
                        mysqli_query($koneksi, "INSERT INTO tb_transaksi(id, gambar, tanggal, transaksi, total, dari_bank, metode, bonus, keterangan, status, id_user, trxid, expired, url) VALUES (NULL, '', '$tanggal', 'Bonus Refferal', '$persen', '', 'Bonus Refferal', '', 'Bonus', 'Sukses', '$reff', 'ByAdmin', '$tanggal', 'chaosapi')");
                        mysqli_query($koneksi, "UPDATE tb_refferal SET bonus = bonus + '$persen' WHERE user_refferal = '$reff'");
                    } else {
                        $errorMsg = isset($TransaksiReff['message']) ? $TransaksiReff['message'] : 'Gagal menambahkan bonus referral ke SGX API';
                        ?>
                        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                        <script type="text/javascript">
                            Swal.fire({
                                title: "Error",
                                text: "<?php echo $errorMsg; ?>",
                                icon: "error",
                                confirmButtonText: "Ok",
                            }).then(function() {
                                window.location = "?page=permintaan_deposit";
                            });
                        </script>
                        <?php
                        exit();
                    }
                }

                // Update saldo dan status transaksi untuk user
                mysqli_query($koneksi, "UPDATE tb_saldo SET active = active + $total WHERE id_user = '$id_user'");
                mysqli_query($koneksi, "UPDATE tb_transaksi SET status = 'Sukses' WHERE id_user = '$id_user' AND id = '$id'");
            } else {
                $errorMsg = isset($Transaksi['message']) ? $Transaksi['message'] : 'Gagal terhubung ke SGX API';
                ?>
                <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                <script type="text/javascript">
                    Swal.fire({
                        title: "Error",
                        text: "<?php echo $errorMsg; ?>",
                        icon: "error",
                        confirmButtonText: "Ok",
                    }).then(function() {
                        window.location = "?page=permintaan_deposit";
                    });
                </script>
                <?php
                exit();
            }
        } else {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Not Found",
                    text: "Data Tidak Ditemukan",
                    icon: "question",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=permintaan_deposit";
                });
            </script>
            <?php
            exit();
        }
    }

    // Jika semua transaksi sukses
    ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script type="text/javascript">
        Swal.fire({
            title: "Sukses",
            text: "Konfirmasi Deposit Berhasil",
            icon: "success",
            confirmButtonText: "Ok",
        }).then(function() {
            window.location = "?page=permintaan_deposit";
        });
    </script>
    <?php
}

if (isset($_POST['tolak_selected'])) {
    foreach ($selected_ids as $id) {
        $id = mysqli_real_escape_string($koneksi, $id);
        $query = mysqli_query($koneksi, "UPDATE tb_transaksi SET status = 'Ditolak' WHERE id = '$id'");
        if ($query) {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Success",
                    text: "Permintaan Deposit Berhasil Ditolak",
                    icon: "success",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=permintaan_deposit";
                });
            </script>
            <?php
            exit();
        } else {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Error",
                    text: "Penolakan Deposit Gagal",
                    icon: "error",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=permintaan_deposit";
                });
            </script>
            <?php
            exit();
        }
    }
}

if (isset($_POST['suspend_selected'])) {
    foreach ($selected_ids as $id) {
        $id = mysqli_real_escape_string($koneksi, $id);
        $query = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE id = '$id'");
        $data = mysqli_fetch_array($query);
        $id_user = $data['id_user'];

        $query_user = mysqli_query($koneksi, "UPDATE tb_user SET status = 'Suspend' WHERE extplayer = '$id_user'");
        $query_trx = mysqli_query($koneksi, "UPDATE tb_transaksi SET status = 'Suspend' WHERE id = '$id'");

        if ($query_user && $query_trx) {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Success",
                    text: "Member Berhasil Ditangguhkan",
                    icon: "success",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=permintaan_deposit";
                });
            </script>
            <?php
            exit();
        } else {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Error",
                    text: "Penangguhan Member Gagal",
                    icon: "error",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=permintaan_deposit";
                });
            </script>
            <?php
            exit();
        }
    }
}

if (!isset($_POST['selected_ids'])) {
    ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script type="text/javascript">
        Swal.fire({
            title: "Error",
            text: "Tidak ada permintaan yang dipilih",
            icon: "error",
            confirmButtonText: "Ok",
        }).then(function() {
            window.location = "?page=permintaan_deposit";
        });
    </script>
    <?php
}
?>