<?php
if ($c['level'] == "superadmin") {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $agent_code = filter_input(INPUT_POST, 'agent_code', FILTER_SANITIZE_STRING);
        $signature = filter_input(INPUT_POST, 'signature', FILTER_SANITIZE_STRING);
        $url_request = filter_input(INPUT_POST, 'url_request', FILTER_SANITIZE_URL);

        if (!empty($agent_code) && !empty($signature) && !empty($url_request)) {
            if (isset($koneksi) && $koneksi) {
                $stmt = $koneksi->prepare("UPDATE config SET agent_code = ?, signature = ?, url_request = ? WHERE id = 1");
                $stmt->bind_param("sss", $agent_code, $signature, $url_request);
                $stmt->execute();
                $stmt->close();
            }
            echo "<script src='https://cdn.jsdelivr.net/npm/sweetalert2@11'></script>";
            echo "<script>
                    window.addEventListener('load', function() {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: 'API status updated successfully.',
                            showConfirmButton: true
                        });
                    });
                  </script>";
        }
    }
    ?>
    <div class="page-breadcrumb">
        <div class="row">
            <div class="col-5 align-self-center">
                <h4 class="page-title">API Manage</h4>
            </div>
            <div class="col-7 align-self-center">
                <div class="d-flex align-items-center justify-content-end"></div>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-body">
                        <h4 class="card-title">Manage Game API</h4>
                        <br>
                        <h4 class="card-title">Update API</h4>
                        <form method="post">
                            <?php
                            $query = mysqli_query($koneksi, "SELECT * FROM config WHERE id = 1");
                            $data = mysqli_fetch_assoc($query);
                            ?>
                        <div class="form-group">
                            <label for="agent_code">Agent Code</label>
                            <input type="text" class="form-control" id="agent_code" name="agent_code" required 
                                   value="<?= htmlspecialchars($data['agent_code']); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="signature">Signature</label>
                            <input type="password" class="form-control" id="signature" name="signature" required 
                                   value="<?= htmlspecialchars($data['signature']); ?>">
                        </div>
                        
                        <div class="form-group">
                            <label for="url_request">URL Request</label>
                            <input type="text" class="form-control" id="url_request" name="url_request" required 
                                   value="<?= htmlspecialchars($data['url_request']); ?>">
                        </div>
                        
                        <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php
} else {
    header("Location: ?page=dashboard");
    exit;
}
?>