<div class="page-breadcrumb">
    <div class="row">
        <div class="col-5 align-self-center">
            <h4 class="page-title">Riwayat Transaksi Member</h4>
        </div>
        <div class="col-7 align-self-center">
            <div class="d-flex align-items-center justify-content-end">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item">
                            <a href="#">Riwayat Transaksi</a>
                        </li>
                        <li class="breadcrumb-item active" aria-current="page">Menu Riwayat Transaksi</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="card-title">Riwayat Total Deposit dan Withdraw Member</h4>
                    <div class="form-group">
                        <label for="filter">Filter Data:</label>
                        <select id="filter" class="form-control">
                            <option value="all">Semua</option>
                            <option value="today" selected>Harian</option>
                            <option value="monthly">Bulanan</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="filter_date">Pilih Tanggal:</label>
                        <input type="date" id="filter_date" class="form-control">
                    </div>
                </div>
                <div class="table-responsive">
                    <table id="zero_config" class="table table-striped table-bordered">
                        <thead>
                            <tr>
                                <th scope="col">#</th>
                                <th scope="col">Username</th>
                                <th scope="col">Total Deposit</th>
                                <th scope="col">Total Withdraw</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        // Query to get all users
                        $query_users = mysqli_query($koneksi, "SELECT * FROM tb_user ORDER BY username ASC");
                        $no = 1;
                        while ($user = mysqli_fetch_array($query_users)) {
                            $id_user = $user['extplayer'];
                            $username = $user['username'];

                            // Query to calculate total deposit per user
                            $query_deposit = mysqli_query($koneksi, "SELECT SUM(total) as total_deposit FROM tb_transaksi WHERE id_user = '$id_user' AND transaksi = 'Top Up' AND status = 'Sukses'");
                            $data_deposit = mysqli_fetch_array($query_deposit);
                            $total_deposit = $data_deposit['total_deposit'] ? $data_deposit['total_deposit'] : 0;

                            // Query to calculate total withdraw per user
                            $query_withdraw = mysqli_query($koneksi, "SELECT SUM(total) as total_withdraw FROM tb_transaksi WHERE id_user = '$id_user' AND transaksi = 'withdraw' AND status = 'Sukses'");
                            $data_withdraw = mysqli_fetch_array($query_withdraw);
                            $total_withdraw = $data_withdraw['total_withdraw'] ? $data_withdraw['total_withdraw'] : 0;
                            ?>
                            <tr class="data-row">
                                <th scope="row"><?php echo $no++; ?></th>
                                <td><?php echo $username; ?></td>
                                <td>Rp. <?php echo number_format($total_deposit); ?></td>
                                <td>Rp. <?php echo number_format($total_withdraw); ?></td>
                            </tr>
                            <?php
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

</div>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        var filterSelect = document.getElementById('filter');
        var filterDate = document.getElementById('filter_date');
        var rows = document.querySelectorAll('.data-row');

        // Set default filter to 'today' (harian)
        filterSelect.value = 'today';

        filterSelect.addEventListener('change', filterData);
        filterDate.addEventListener('change', filterData);

        function filterData() {
            var filterValue = filterSelect.value;
            var selectedDate = filterDate.value;
            rows.forEach(function(row) {
                var usernameCell = row.querySelector('td:nth-child(2)');
                var tanggalDepositCell = row.querySelector('td:nth-child(3)');
                var tanggalWithdrawCell = row.querySelector('td:nth-child(4)');
                var tanggalDeposit = tanggalDepositCell.textContent.trim();
                var tanggalWithdraw = tanggalWithdrawCell.textContent.trim();

                var showRow = false;

                if (filterValue === 'all') {
                    showRow = true;
                } else if (filterValue === 'today') {
                    var today = new Date();
                    var rowDateDeposit = new Date(tanggalDeposit);
                    var rowDateWithdraw = new Date(tanggalWithdraw);

                    if (today.toDateString() === rowDateDeposit.toDateString() || today.toDateString() === rowDateWithdraw.toDateString()) {
                        showRow = true;
                    }
                } else if (filterValue === 'monthly') {
                    var today = new Date();
                    var rowDateDeposit = new Date(tanggalDeposit);
                    var rowDateWithdraw = new Date(tanggalWithdraw);
                    var thisMonth = today.getMonth();

                    if ((today.getFullYear() === rowDateDeposit.getFullYear() && thisMonth === rowDateDeposit.getMonth()) ||
                        (today.getFullYear() === rowDateWithdraw.getFullYear() && thisMonth === rowDateWithdraw.getMonth())) {
                        showRow = true;
                    }
                }

                if (selectedDate) {
                    var rowDateDeposit = new Date(tanggalDeposit);
                    var rowDateWithdraw = new Date(tanggalWithdraw);
                    var selectedDateObj = new Date(selectedDate);

                    if (rowDateDeposit.toDateString() === selectedDateObj.toDateString() || rowDateWithdraw.toDateString() === selectedDateObj.toDateString()) {
                        showRow = true;
                    }
                }

                row.style.display = showRow ? 'table-row' : 'none';
            });
        }
    });
</script>
