<?php
require '../../vendor/autoload.php';
require '../../function/config.php';
use Aws\Exception\AwsException;

if ($c['level'] == "superadmin") {
    if (isset($_POST['upload'])) {
        $ekstensi_diperbolehkan = array('png', 'jpg', 'jpeg');
        $nama = $_FILES['file']['name'];
        $x = explode('.', $nama);
        $ekstensi = strtolower(end($x));
        $ukuran = $_FILES['file']['size'];
        $file_tmp = $_FILES['file']['tmp_name'];
        $judul = mysqli_real_escape_string($koneksi, htmlspecialchars($_POST['judul'], ENT_QUOTES, 'UTF-8'));
        $deskripsi = mysqli_real_escape_string($koneksi, htmlspecialchars($_POST['deskripsi'], ENT_QUOTES, 'UTF-8'));
        $tanggal = mysqli_real_escape_string($koneksi, htmlspecialchars($_POST['tanggal'], ENT_QUOTES, 'UTF-8'));
        $status = mysqli_real_escape_string($koneksi, htmlspecialchars($_POST['status'], ENT_QUOTES, 'UTF-8'));        
        if (in_array($ekstensi, $ekstensi_diperbolehkan) === true) {
            if ($ukuran < 1044070) {
                $namaFileS3 = time() . '_' . $nama;
                $new_filename = uniqid() . '.' . $ekstensi;
                $upload_path = $news . $new_filename;

                try {
                    $result = $s3->putObject([
                        'Bucket' => $bucketName,
                        'Key'    => $upload_path,
                        'Body'   => fopen($file_tmp, 'rb'),
                        'ACL'    => 'public-read',
                    ]);

                    $fileUrl = $result['ObjectURL'];

                    $query = mysqli_query($koneksi, "INSERT INTO tb_news (gambar, judul, deskripsi, tanggal, status) VALUES ('$fileUrl', '$judul', '$deskripsi', '$tanggal', '$status' ");
                    if ($query) {
?>
                        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                        <script type="text/javascript">
                            Swal.fire({
                                title: "Sukses!",
                                text: "Data berita Berhasil Ditambahkan",
                                icon: "success",
                                confirmButtonText: "Ok",
                            }).then(function() {
                                window.location = "?page=news";
                            });
                        </script>
                    <?php
                    } else {
                        throw new Exception("Gagal menyimpan URL ke database.");
                    }
                } catch (AwsException $e) {
                    $errorMessage = $e->getMessage();
                    ?>
                    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                    <script type="text/javascript">
                        Swal.fire({
                            title: "Error!",
                            text: "Gagal Mengupload Gambar berita",
                            icon: "error",
                            confirmButtonText: "Ok",
                        }).then(function() {
                            window.location = "?page=news";
                        });
                    </script>
                <?php
                } catch (Exception $e) {
                    $errorMessage = $e->getMessage();
                ?>
                    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                    <script type="text/javascript">
                        Swal.fire({
                            title: "Error!",
                            text: "Gagal Memindahkan Gambar",
                            icon: "error",
                            confirmButtonText: "Ok",
                        }).then(function() {
                            window.location = "?page=news";
                        });
                    </script>
                <?php
                }
            } else {
                ?>
                <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
                <script type="text/javascript">
                    Swal.fire({
                        title: "Error!",
                        text: "Ukuran Gambar Terlalu Besar",
                        icon: "error",
                        confirmButtonText: "Ok",
                    }).then(function() {
                        window.location = "?page=news";
                    });
                </script>
            <?php
            }
        } else {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>';
            <script type="text/javascript">
                Swal.fire({
                    title: "Error!",
                    text: "Hanya Bisa Mengupload Ekstensi PNG, JPG, JPEG",
                    icon: "error",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=news";
                });
            </script>';
    <?php
        }
    }
    ?>
<?php
} else {
?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script type="text/javascript">
        Swal.fire({
            title: "Error!",
            text: "Anda tidak memiliki akses!",
            icon: "error",
            confirmButtonText: "Ok",
        }).then(function() {
            window.location = "?page=dashboard";
        });
    </script>
<?php
}
?>