<?php
include '../../function/connect.php';

// Pastikan form telah disubmit
if (isset($_POST['submit'])) {
    // Ambil data dari form dan lakukan sanitasi
    $id_user = mysqli_real_escape_string($koneksi, $_POST['id_user']);
    $nominal = mysqli_real_escape_string($koneksi, $_POST['nominal']);
    $jenis = mysqli_real_escape_string($koneksi, $_POST['jenis']);

    // Validasi nominal sebagai angka
    if (!ctype_digit($nominal)) {
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Nominal tidak valid.",
                icon: "error",
                confirmButtonText: "Ok",
            }).then(function() {
                window.location = "?page=saldo_member";
            });
        </script>
        <?php
        exit();
    }
    $nominal = (int)$nominal;

    // Dapatkan saldo aktif pengguna
    $getBalance = mysqli_query($koneksi, "SELECT * FROM `tb_saldo` WHERE id_user = '$id_user'") or die(mysqli_error($koneksi));
    $gb = mysqli_fetch_array($getBalance);
    $saldoAktif = $gb['active'];

    // Waktu transaksi
    $created_date = date('Y-m-d H:i:s');

    // Ambil konfigurasi dari tabel config
    $sql_config = "SELECT url_request, agent_code, signature FROM config WHERE id = 1";
    $result_config = mysqli_query($koneksi, $sql_config);
    if (mysqli_num_rows($result_config) == 0) {
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak ditemukan.",
                icon: "error",
                confirmButtonText: "Ok",
            }).then(function() {
                window.location = "?page=saldo_member";
            });
        </script>
        <?php
        exit();
    }
    $config = mysqli_fetch_assoc($result_config);
    $url_request = $config['url_request'];
    $agent_code = $config['agent_code'];
    $signature = $config['signature'];

    // Tentukan perintah berdasarkan jenis
    $command = ($jenis == "0") ? 'user_deposit' : 'user_withdraw';

    // Buat payload untuk SGX API
    $postArray = [
        'command' => $command,
        'agent_code' => $agent_code,
        'signature' => $signature,
        'user_code' => $id_user,
        'amount' => $nominal
    ];
    $jsonData = json_encode($postArray);
    $headerArray = ['Content-Type: application/json'];

    // Kirim permintaan ke SGX API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_request);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    $output = curl_exec($ch);
    curl_close($ch);

    // Parse respon dari SGX API
    $Transaksi = json_decode($output, true);

    // Proses transaksi berdasarkan jenis
    if (isset($Transaksi['status']) && $Transaksi['status'] == 200 && $Transaksi['message'] == 'SUCCESS') {
        // Tentukan detail transaksi berdasarkan jenis
        $transaksi_type = ($jenis == "0") ? 'Top Up Saldo' : 'Saldo Dikurangi';
        $saldo_update = ($jenis == "0") ? "active + $nominal" : "active - $nominal";

        // Tambahkan transaksi ke database
        $query100 = mysqli_query($koneksi, "INSERT INTO tb_transaksi(id, gambar, tanggal, transaksi, total, dari_bank, metode, bonus, keterangan, status, id_user, trxid, expired, url) VALUES (NULL, 'chaos', '$created_date', '$transaksi_type', '$nominal', 'System', 'System', 'none', 'Top Up', 'Sukses', '$id_user', 'ByAdmin', '$created_date', 'chaosapi')");

        // Update saldo
        $query4 = mysqli_query($koneksi, "UPDATE tb_saldo SET active = $saldo_update WHERE id_user = '$id_user'");

        if ($query100 && $query4) {
            // Redirect jika berhasil
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Sukses",
                    text: "Transaksi <?php echo $transaksi_type; ?> berhasil.",
                    icon: "success",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=saldo_member";
                });
            </script>
            <?php
        } else {
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Error",
                    text: "Gagal menyimpan transaksi ke database.",
                    icon: "error",
                    confirmButtonText: "Ok",
                }).then(function() {
                    window.location = "?page=saldo_member";
                });
            </script>
            <?php
        }
    } else {
        // Gagal transaksi
        $msgText = isset($Transaksi['message']) ? $Transaksi['message'] : 'Gagal terhubung ke SGX API';
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "<?php echo $msgText; ?>",
                icon: "error",
                confirmButtonText: "Ok",
            }).then(function() {
                window.location = "?page=saldo_member";
            });
        </script>
        <?php
    }
}
?>