<?php
// callback.php
// Menangani webhook QRIS dari rest.otomatis.vip, integrasi dengan SGX API, simpan ke tb_transaksi setelah deposit sukses

include 'function/connect.php'; // Koneksi ke database

ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/callback.log');
ini_set('max_execution_time', 60);
error_reporting(E_ALL);
date_default_timezone_set('Asia/Makassar'); // WITA

// Fungsi untuk menulis log
function writeLog($message) {
    $log_entry = "[" . date('Y-m-d H:i:s \T') . "] $message\n--------------------------------------------------\n";
    file_put_contents(__DIR__ . '/callback.log', $log_entry, FILE_APPEND | LOCK_EX);
}

writeLog("Script started");

// Fungsi untuk tes koneksi ke API
function testApiConnection($url, $post_data, $api_name) {
    writeLog("Starting $api_name API connection test");
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post_data));
    curl_setopt($ch, CURLOPT_VERBOSE, true);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $verbose = fopen('php://temp', 'w+');
    curl_setopt($ch, CURLOPT_STDERR, $verbose);

    $response = curl_exec($ch);
    $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    $curl_error = curl_error($ch);

    rewind($verbose);
    $verbose_log = stream_get_contents($verbose);
    fclose($verbose);

    $log_message = "Test $api_name API\nURL: $url\nRequest: " . json_encode($post_data) . "\nHTTP Code: $http_code\nResponse: " . ($response ?: 'No response') . "\ncURL Verbose: $verbose_log";
    
    if ($response === false) {
        $log_message .= "\nERROR: Failed to connect to $api_name - cURL error: $curl_error";
        writeLog($log_message);
        return ['status' => false, 'error' => "Failed to connect to $api_name: $curl_error"];
    }

    $response_data = json_decode($response, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
        $log_message .= "\nERROR: Invalid JSON response from $api_name - " . json_last_error_msg();
        writeLog($log_message);
        return ['status' => false, 'error' => "Invalid JSON response from $api_name"];
    }

    $log_message .= "\nResult: Connection to $api_name successful (HTTP $http_code)";
    writeLog($log_message);
    return ['status' => true, 'http_code' => $http_code, 'response' => $response_data];
}

// Log semua request masuk
$request_method = $_SERVER['REQUEST_METHOD'];
$request_headers = getallheaders();
writeLog("Request Received: Method=$request_method, Headers=" . json_encode($request_headers));

// Log raw input
$raw_input = file_get_contents('php://input');
writeLog("Raw Input Received: " . ($raw_input ?: 'Empty'));

// Coba decode JSON
$webhook_data = json_decode($raw_input, true);
writeLog("Webhook JSON Parsed: " . json_encode($webhook_data));

// UUID untuk QRIS
$merchant_id = '7b0ce385-670e-443a-b0e9-58bfb8890544';

// Jika tidak ada data webhook dan akses via GET, lakukan tes koneksi
if ($request_method === 'GET') {
    writeLog("Direct URL Access Detected - Running Connection Tests");

    // Tes koneksi ke QRIS API
    $qris_test_data = [
        'merchant_id' => $merchant_id,
        'status' => 'success'
    ];
    $qris_result = testApiConnection('https://rest.otomatis.vip/api/merchant_active', $qris_test_data, 'QRIS');

    // Tes koneksi ke SGX API
    $sgx_test_data = [
        'command' => 'agent_info',
        'agent_code' => 'firzartg',
        'signature' => '3517d2ad66c5fbcb8f3cca6a8bb71919'
    ];
    $sgx_result = testApiConnection('https://sgxcenter.xyz/api/', $sgx_test_data, 'SGX');

    // Tampilkan hasil tes
    $response = [
        'qris_api' => $qris_result,
        'sgx_api' => $sgx_result
    ];
    http_response_code(200);
    header('Content-Type: application/json');
    echo json_encode($response);
    exit();
}

// Validasi metode POST untuk webhook
if ($request_method !== 'POST') {
    writeLog("ERROR: Invalid request method: $request_method. Expected POST");
    http_response_code(405);
    echo json_encode(['status' => false, 'error' => 'Method Not Allowed. Use POST']);
    exit();
}

// Validasi data webhook
if (!$webhook_data) {
    writeLog("ERROR: Invalid or empty webhook data - JSON Error: " . json_last_error_msg());
    http_response_code(400);
    echo json_encode(['status' => false, 'error' => 'Invalid webhook data']);
    exit();
}

$required_fields = ['status', 'merchant_id', 'terminal_id', 'amount', 'trx_id', 'vendor'];
$missing_fields = array_diff($required_fields, array_keys($webhook_data));
if (!empty($missing_fields) || $webhook_data['status'] !== 'success') {
    writeLog("ERROR: Invalid webhook data. Missing fields: " . implode(', ', $missing_fields) . ", Status: " . ($webhook_data['status'] ?? 'N/A'));
    http_response_code(200); // Return 200 agar webhook tidak di-retry
    echo json_encode(['status' => false, 'error' => 'Invalid webhook data']);
    exit();
}

$trx_id = $webhook_data['trx_id'];
$username = $webhook_data['terminal_id'];
$amount = (int)$webhook_data['amount'];
$received_merchant_id = $webhook_data['merchant_id'];
$vendor = $webhook_data['vendor'];
writeLog("Webhook Fields: trx_id=$trx_id, username=$username, amount=$amount, merchant_id=$received_merchant_id, vendor=$vendor");

// Verifikasi UUID
if ($received_merchant_id !== $merchant_id) {
    writeLog("ERROR: Invalid UUID: $received_merchant_id, Expected: $merchant_id");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Invalid UUID']);
    exit();
}
writeLog("UUID Verified: $merchant_id");

// Cari extplayer berdasarkan username di tb_user
$sql = "SELECT extplayer FROM tb_user WHERE username = '" . mysqli_real_escape_string($koneksi, $username) . "'";
$result = mysqli_query($koneksi, $sql);
if (!$result) {
    $db_error = mysqli_error($koneksi);
    writeLog("ERROR: Database query failed: $db_error");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Database query failed']);
    exit();
}

if (mysqli_num_rows($result) === 0) {
    writeLog("ERROR: User not found for username: $username");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'User not found']);
    exit();
}

$row = mysqli_fetch_assoc($result);
$user_code = $row['extplayer'];
writeLog("Extplayer retrieved for username $username: $user_code");

// Persiapan request ke SGX API
$sgx_api_url = "https://sgxcenter.xyz/api/";
$sgx_data = [
    'command' => 'user_deposit',
    'agent_code' => 'firzartg',
    'user_code' => $user_code,
    'amount' => $amount,
    'signature' => '3517d2ad66c5fbcb8f3cca6a8bb71919'
];
writeLog("Preparing SGX Request: " . json_encode($sgx_data));

// Kirim request ke SGX API
$ch = curl_init($sgx_api_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($sgx_data));
curl_setopt($ch, CURLOPT_VERBOSE, true);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
curl_setopt($ch, CURLOPT_TIMEOUT, 30);
$verbose = fopen('php://temp', 'w+');
curl_setopt($ch, CURLOPT_STDERR, $verbose);

$sgx_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$curl_error = curl_error($ch);

rewind($verbose);
$verbose_log = stream_get_contents($verbose);
fclose($verbose);
writeLog("SGX Request Sent\nHTTP Code: $http_code\nResponse: " . ($sgx_response ?: 'No response') . "\ncURL Verbose: $verbose_log");

if ($sgx_response === false) {
    writeLog("ERROR: SGX cURL error: $curl_error");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Failed to connect to SGX']);
    exit();
}

$sgx_response_data = json_decode($sgx_response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    writeLog("ERROR: SGX JSON decode error: " . json_last_error_msg());
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Invalid SGX response']);
    exit();
}

if ($http_code !== 200 || !isset($sgx_response_data['status']) || $sgx_response_data['status'] !== 200) {
    $error_message = $sgx_response_data['message'] ?? 'Unknown error';
    writeLog("ERROR: SGX deposit failed: $error_message");
    // Simpan transaksi dengan status Panding
    $insert_sql = "INSERT INTO tb_transaksi (tanggal, transaksi, total, dari_bank, metode, bonus, keterangan, status, id_user, trxid, gambar, expired, url) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = mysqli_prepare($koneksi, $insert_sql);
    if (!$stmt) {
        $db_error = mysqli_error($koneksi);
        writeLog("ERROR: Failed to prepare insert statement: $db_error");
        http_response_code(200);
        echo json_encode(['status' => false, 'error' => 'Failed to prepare database statement']);
        exit();
    }

    $tanggal = date('Y-m-d H:i:s');
    $transaksi = 'Deposit QRIS';
    $dari_bank = 'QRIS';
    $metode = $vendor;
    $bonus = 0;
    $keterangan = 'Deposit via QRIS, trx_id: ' . $trx_id;
    $status = 'Panding';
    $gambar = 'https://via.placeholder.com/150';
    $expired = date('Y-m-d H:i:s', strtotime('+24 hours'));
    $url = 'https://example.com/trx_' . $trx_id;
    mysqli_stmt_bind_param($stmt, 'ssissssssssss', $tanggal, $transaksi, $amount, $dari_bank, $metode, $bonus, $keterangan, $status, $user_code, $trx_id, $gambar, $expired, $url);
    if (!mysqli_stmt_execute($stmt)) {
        $db_error = mysqli_error($koneksi);
        writeLog("ERROR: Failed to insert transaction: $db_error");
        mysqli_stmt_close($stmt);
        http_response_code(200);
        echo json_encode(['status' => false, 'error' => 'Failed to save transaction']);
        exit();
    }
    mysqli_stmt_close($stmt);
    writeLog("Transaction saved with status Panding: trx_id=$trx_id, user_code=$user_code");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'SGX deposit failed: ' . $error_message]);
    exit();
}

// Simpan transaksi ke tb_transaksi dengan status Sukses
$insert_sql = "INSERT INTO tb_transaksi (tanggal, transaksi, total, dari_bank, metode, bonus, keterangan, status, id_user, trxid, gambar, expired, url) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
$stmt = mysqli_prepare($koneksi, $insert_sql);
if (!$stmt) {
    $db_error = mysqli_error($koneksi);
    writeLog("ERROR: Failed to prepare insert statement: $db_error");
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Failed to prepare database statement']);
    exit();
}

$tanggal = date('Y-m-d H:i:s');
$transaksi = 'Deposit QRIS';
$dari_bank = 'QRIS';
$metode = $vendor;
$bonus = 0;
$keterangan = 'Deposit via QRIS, trx_id: ' . $trx_id;
$status = 'Sukses';
$gambar = 'https://via.placeholder.com/150';
$expired = date('Y-m-d H:i:s', strtotime('+24 hours'));
$url = 'https://example.com/trx_' . $trx_id;
mysqli_stmt_bind_param($stmt, 'ssissssssssss', $tanggal, $transaksi, $amount, $dari_bank, $metode, $bonus, $keterangan, $status, $user_code, $trx_id, $gambar, $expired, $url);
if (!mysqli_stmt_execute($stmt)) {
    $db_error = mysqli_error($koneksi);
    writeLog("ERROR: Failed to insert transaction: $db_error");
    mysqli_stmt_close($stmt);
    http_response_code(200);
    echo json_encode(['status' => false, 'error' => 'Failed to save transaction']);
    exit();
}
mysqli_stmt_close($stmt);
writeLog("SGX Deposit Success: agent_balance=" . ($sgx_response_data['data']['agent_balance'] ?? 'unknown') . ", user_balance=" . ($sgx_response_data['data']['user_balance'] ?? 'unknown') . ", trx_id=$trx_id");
writeLog("Transaction saved with status Sukses: trx_id=$trx_id, user_code=$user_code");

// Respon sukses
http_response_code(200);
echo json_encode(['status' => true, 'message' => 'Deposit processed successfully']);
writeLog("Webhook Processing Completed Successfully");
exit();
?>