<main id="main-route">
    <div class="main-content register post">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="register__container">
                        <div class="page-header"><i class="fas fa-user-alt mr-2"></i>| Formulir Pendaftaran</div>
                        <form id="register-form" method="POST" action="/desktop/function/daftar_akun.php">
                            <div class="register-form">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="register__note">
                                            <div class="note__head">Catatan :</div>
                                            <div class="note__content">
                                                *Nama pengguna harus terdiri dari 6 hingga 15 karakter dan mengunakan alfabet.<br>
                                                *Kata sandi harus terdiri dari 8 hingga 25 karakter.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="username_register">Nama Pengguna*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" type="text" name="username"
                                                id="username_register" minlength="6" maxlength="15"
                                                placeholder="Nama Pengguna*" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="password">Kata Sandi*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" type="password" name="password" id="password"
                                                minlength="8" maxlength="25" placeholder="Kata Sandi" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="rePassword">Konfirmasi Kata Sandi*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" type="password" name="konfirmasi_pass"
                                                minlength="8" maxlength="25"
                                                placeholder="Konfirmasi Kata Sandi" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="register__notemail">
                                            <div class="note__content">
                                                *Harap mengisi email dan nomor ponsel yang aktif untuk memudahkan perubahan password dan informasi promo.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="email">Email*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" value="" type="email" name="email"
                                                id="email" minlength="6" maxlength="50"
                                                placeholder="nama@domain.com" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="bank">Bank*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <select class="form-control" name="bank" id="bank">
                                                <option value="">--- Pilih Bank ---</option>
                                                <optgroup label="bank">
                                                    <option value="bca" data-max="10"
                                                        data-min="10">
                                                        BCA
                                                    </option>
                                                    <option value="mandiri" data-max="13"
                                                        data-min="13">
                                                        MANDIRI
                                                    </option>
                                                    <option value="bri" data-max="15"
                                                        data-min="15">
                                                        BRI
                                                    </option>
                                                    <option value="cimb" data-max="13"
                                                        data-min="12">
                                                        CIMB
                                                    </option>
                                                    <option value="bni" data-max="10"
                                                        data-min="10">
                                                        BNI
                                                    </option>
                                                    <option value="bcadigi" data-max="12"
                                                        data-min="10">
                                                        BCA DIGITAL
                                                    </option>
                                                    <option value="seabank" data-max="0"
                                                        data-min="0">
                                                        SEABANK
                                                    </option>
                                                    <option value="bsi" data-max="0"
                                                        data-min="0">
                                                        BSI
                                                    </option>
                                                    <option value="danamon" data-max="12"
                                                        data-min="10">
                                                        DANAMON
                                                    </option>
                                                </optgroup>
                                                <optgroup label="epayment">
                                                    <option value="gopay" data-max="0"
                                                        data-min="0">
                                                        GOPAY
                                                    </option>
                                                    <option value="dana" data-max="0"
                                                        data-min="0">
                                                        DANA
                                                    </option>
                                                    <option value="ovo" data-max="0"
                                                        data-min="0">
                                                        OVO
                                                    </option>
                                                    <option value="linkaja" data-max="0"
                                                        data-min="0">
                                                        LINKAJA
                                                    </option>
                                                    <option value="sakuku" data-max="0"
                                                        data-min="0">
                                                        SAKUKU
                                                    </option>
                                                </optgroup>
                                            </select>
                                            <span id="bank-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" id="phoneInput">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="phone">Nomor Ponsel*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">+62</span>
                                                </div>
                                                <input class="form-control" value="" type="text" name="no_whatsapp"
                                                    id="phone" minlength="8" maxlength="20" placeholder="Nomor Ponsel*" required="">
                                            </div>
                                            <span id="phone-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" id="accountName">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="accName">Nama Rekening*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" value="" type="text" name="pemilik_rekening"
                                                id="accName" minlength="2" maxlength="100"
                                                placeholder="Nama Sesuai Rekening" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group" id="accountNumber">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="accNumber">Nomor Rekening*</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <input class="form-control" value="" type="text" name="norek"
                                                id="accNumber" minlength="" maxlength=""
                                                placeholder="Nomor Sesuai Rekening" required="">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="referral">Referral</label>
                                        </div>
                                        <div class="col-lg-8">
                                            <?php
                                                $reff = isset($_GET['reff']) ? $_GET['reff'] : '';

                                            ?>
                                            <input class="form-control" type="text" name="refferal" readonly="" value="<?php echo $reff ?>" id="referral" minlength="4"
                                                maxlength="12"
                                                value="" autocomplete="off">
                                            <span id="referral-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-4 d-flex align-items-center justify-content-start">
                                            <label for="captcha">Captcha*</label>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="cap-img">
                                                <div class="cap-content">
                                                    <?php $captchaNumber = rand(0, 999999); ?>
                                                    <div style="font-size: 24px; background-color: white; color: black; padding: 4px;"><?php echo $captchaNumber; ?></div>
                                                    <input type="hidden" name="captcha_asli" value="<?php echo $captchaNumber; ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-lg-4">
                                            <div class="cap-content">
                                                <input class="form-control input-code" type="number" name="captcha" id="captcha"
                                                    placeholder="Captcha" required="">
                                            </div>
                                            <span id="captcha-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <label for="term" class="register-terms">
                                                <input type="checkbox" name="term" id="term">
                                                <span class="text-justify">Saya telah berusia lebih dari 21 tahun, telah membaca, dan menerima <u><a href="/help">syarat dan ketentuan</a></u> yang dipasang di situs ini, jika Saya melanggar salah satu syarat dan ketentuan, maka situs berhak untuk menghentikan atau menangguhkan akun Saya.</span>
                                            </label>
                                            <span id="term-error"></span>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <button id="registerButton" class="daftar btn-custom button-submit" type="submit" name="submit" value="Daftar">
                                            Buat Akun
                                            <div id="progressButton" class="progress-line"></div>
                                        </button>
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="post__container ">
                    <div class="other-post">
                        <div class="other-header">Promosi Terakhir</div>
                        <?php
                        $query = mysqli_query($koneksi, "SELECT * FROM tb_bonus");
                        while ($data = mysqli_fetch_array($query)) {
                        ?>
                            <a href="?page=promosi">
                                <div class="other-item">
                                    <div class="img">
                                        <img src="<?php echo $data['gambar'] ?>" alt="">
                                    </div>
                                    <div class="content">
                                        <div class="title"><?php echo htmlspecialchars($data['judul']); ?></div>
                                        <div class="read-more">Selengkapnya</div>
                                    </div>
                                </div>
                            </a>
                        <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="game__seo">
            <div hidden id="title-seo"><?php echo $judul ?>: Register</div>
            <div class="seo-content showFooter">
                <div class="register__container mt-5">
                    <h1>Register</h1>
                    <p>Register</p>
                </div>
            </div>
        </div>
    </div>
</main>