<?php
ob_start();
include "function/connect.php";
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', '../logs/update_game_error.log');

// Fungsi untuk logging debug
function logDebug($message, $file = '../logs/update_game.log') {
    $timestamp = date('Y-m-d H:i:s');
    if (!file_exists(dirname($file))) {
        mkdir(dirname($file), 0777, true);
    }
    file_put_contents($file, "[$timestamp] $message\n", FILE_APPEND);
}

// Log awal eksekusi
logDebug("Script started: update_game.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    // Ambil konfigurasi dari tabel config
    $stmt = mysqli_prepare($koneksi, "SELECT url_request, agent_code, signature FROM config WHERE id = ?");
    $config_id = 1;
    mysqli_stmt_bind_param($stmt, "i", $config_id);
    mysqli_stmt_execute($stmt);
    $result_config = mysqli_stmt_get_result($stmt);
    if (mysqli_num_rows($result_config) == 0) {
        logDebug("Error: Konfigurasi tidak ditemukan untuk id=1");
        mysqli_stmt_close($stmt);
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak ditemukan. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_game";
            });
        </script>
        <?php
        exit();
    }
    $config = mysqli_fetch_assoc($result_config);
    mysqli_stmt_close($stmt);

    $url_request = $config['url_request'];
    $agent_code = $config['agent_code'];
    $signature = $config['signature'];

    logDebug("Config loaded: url_request=$url_request, agent_code=$agent_code, signature=$signature");

    // Validasi konfigurasi
    if (empty($url_request) || empty($agent_code) || empty($signature)) {
        $errorMessage = "Konfigurasi tidak lengkap: url_request=$url_request, agent_code=$agent_code, signature=$signature";
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak lengkap. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_game";
            });
        </script>
        <?php
        exit();
    }

    // Ambil daftar provider dari tb_provider
    $query = mysqli_query($koneksi, "SELECT provider_code FROM tb_provider");
    if (!$query) {
        $errorMessage = "Gagal mengambil daftar provider: " . mysqli_error($koneksi);
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Gagal mengambil daftar provider. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_game";
            });
        </script>
        <?php
        exit();
    }

    $providers = [];
    while ($row = mysqli_fetch_assoc($query)) {
        $providers[] = $row['provider_code'];
    }
    logDebug("Providers loaded: " . implode(', ', $providers));

    // Hapus semua data di tb_game
    $query = mysqli_query($koneksi, "TRUNCATE TABLE tb_game");
    if (!$query) {
        $errorMessage = "Gagal menghapus data di tb_game: " . mysqli_error($koneksi);
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Gagal menghapus data game. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_game";
            });
        </script>
        <?php
        exit();
    }
    logDebug("Successfully truncated tb_game");

    // Siapkan query untuk menyimpan game
    $stmt = mysqli_prepare($koneksi, "INSERT INTO tb_game (game_provider, game_id, game_code, game_name, game_vendor, game_image, game_type, game_status, created_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    if (!$stmt) {
        $errorMessage = "Gagal menyiapkan prepared statement: " . mysqli_error($koneksi);
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Gagal menyiapkan query. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_game";
            });
        </script>
        <?php
        exit();
    }

    // Hitung jumlah game yang berhasil disimpan
    $successCount = 0;
    foreach ($providers as $provider_code) {
        // Buat payload untuk SGX API (game_list)
        $postArray = [
            'command' => 'game_list',
            'agent_code' => $agent_code,
            'signature' => $signature,
            'provider_code' => $provider_code
        ];
        $jsonData = json_encode($postArray);
        logDebug("API Request Payload for provider $provider_code: $jsonData");

        // Kirim permintaan ke SGX API
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url_request);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        $output = curl_exec($ch);

        // Cek error cURL
        if ($output === false) {
            $curlError = curl_error($ch);
            $errorMessage = "cURL Error for provider $provider_code: $curlError";
            logDebug("Error: $errorMessage");
            curl_close($ch);
            continue; // Lanjutkan ke provider berikutnya
        }
        curl_close($ch);

        // Log respon API
        logDebug("API Response for provider $provider_code: $output");

        // Parse respon dari SGX API
        $response = json_decode($output, true);

        // Cek apakah parsing JSON berhasil
        if (json_last_error() !== JSON_ERROR_NONE) {
            $errorMessage = "JSON Parse Error for provider $provider_code: " . json_last_error_msg();
            logDebug("Error: $errorMessage");
            continue; // Lanjutkan ke provider berikutnya
        }

        // Cek respon API
        if (isset($response['status']) && $response['status'] == 200 && $response['message'] == 'SUCCESS' && isset($response['games'])) {
            foreach ($response['games'] as $game) {
                $game_provider = $game['game_provider'];
                $game_id = 0; // Sesuai contoh tabel
                $game_code = $game['game_code'];
                $game_name = $game['game_name'];
                $game_vendor = $game_code; // Sesuai contoh tabel
                $game_image = isset($game['game_image']) ? $game['game_image'] : null;
                $game_type = $game['game_type'];
                $game_status = $game['game_status'];
                $created_at = date('Y-m-d H:i:s');

                mysqli_stmt_bind_param($stmt, "sisssssis", $game_provider, $game_id, $game_code, $game_name, $game_vendor, $game_image, $game_type, $game_status, $created_at);
                if (mysqli_stmt_execute($stmt)) {
                    $successCount++;
                    logDebug("Inserted game: provider=$game_provider, code=$game_code, name=$game_name");
                } else {
                    logDebug("Failed to insert game: provider=$game_provider, code=$game_code, error=" . mysqli_stmt_error($stmt));
                }
            }
        } else {
            $errorMessage = isset($response['message']) ? $response['message'] : "Gagal mengambil daftar game untuk provider $provider_code.";
            logDebug("Error: API response error for provider $provider_code - $errorMessage");
        }
    }
    mysqli_stmt_close($stmt);

    logDebug("Total games inserted: $successCount");
    ?>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
    <script type="text/javascript">
        Swal.fire({
            title: "Sukses",
            text: "Berhasil memperbarui <?php echo $successCount; ?> game.",
            icon: "success",
            confirmButtonText: "Ok"
        }).then(function() {
            window.location = "?page=update_game";
        });
    </script>
    <?php
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Game List</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
            max-width: 600px;
        }
        .card {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .btn-update {
            background-color: #007bff;
            border-color: #007bff;
            font-size: 1.2rem;
            padding: 10px 20px;
        }
        .btn-update:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header text-center">
                <h3>Update Daftar Game</h3>
            </div>
            <div class="card-body text-center">
                <p>Klik tombol di bawah untuk memperbarui daftar game dari API SGX.</p>
                <form method="POST">
                    <button type="submit" name="update" class="btn btn-update">Update</button>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</body>
</html>