<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);
date_default_timezone_set('Asia/Jakarta');

$id_login = $_SESSION['id'] ?? null;
$extplayer = $_SESSION['extplayer'] ?? null;

include 'function/connect.php';
include 'main/integration.php';

// Cek status maintenance
$queryMaintenance = mysqli_query($koneksi, "SELECT mtweb FROM tb_web WHERE id = 1");
$dataMaintenance = mysqli_fetch_array($queryMaintenance);
$statusMaintenance = $dataMaintenance['mtweb'] ?? 'inactive';

if ($statusMaintenance === 'active') {
    require 'maintenance.php';
    exit;
}

// Ambil data saldo
$query1 = mysqli_query($koneksi, "SELECT active FROM tb_saldo WHERE id_user = '$extplayer' ");
$liat = mysqli_fetch_array($query1);

// Data user
$query2 = mysqli_query($koneksi, "SELECT * FROM tb_user WHERE id = '$id_login' ");
$punya_user = mysqli_fetch_array($query2);

// Data bank
$query3 = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id_user = '$extplayer' ");
$bank_user = mysqli_fetch_array($query3);

$query4 = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id_user = '$extplayer' ");
$b = mysqli_fetch_array($query4);

// Akun bank utama & tambahan
$query_main = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id_user = '$extplayer' AND is_main = 1");
$main_account = mysqli_fetch_array($query_main);

$query_secondary = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE id_user = '$extplayer' AND is_main = 0");
$secondary_accounts = mysqli_fetch_all($query_secondary, MYSQLI_ASSOC);

// Kontak
$query1010 = mysqli_query($koneksi, "SELECT * FROM tb_contact");
$ssa = mysqli_fetch_array($query1010);

$whatsapp   = htmlspecialchars($ssa['no_whatsapp'] ?? '');
$id_livechat= htmlspecialchars($ssa['id_livechat'] ?? '');
$facebook   = htmlspecialchars($ssa['facebook'] ?? '');

// Data web
$cuk = mysqli_query($koneksi, "SELECT * FROM tb_web LIMIT 1");
$cek_web = mysqli_fetch_array($cuk);

// Ambil domain aktif terakhir (tanpa canonical)
$q_domain = mysqli_query($koneksi, "SELECT domain_name FROM tb_domains WHERE status = 'active' ORDER BY id DESC LIMIT 1");
$domain = mysqli_fetch_assoc($q_domain);

if ($domain && !empty($domain['domain_name'])) {
    $urlweb = 'https://' . $domain['domain_name'];
} else {
    $urlweb = htmlspecialchars($cek_web['url'] ?? '');
}

// Pakai data dari tb_web untuk yang lain
$logo      = htmlspecialchars($cek_web['logo'] ?? '');
$favicon   = htmlspecialchars($cek_web['icon_web'] ?? '');
$min_depo  = htmlspecialchars($cek_web['min_depo'] ?? '');
$min_wd    = htmlspecialchars($cek_web['min_wd'] ?? '');
$title     = htmlspecialchars($cek_web['title'] ?? '');
$deskripsi = htmlspecialchars($cek_web['deskripsi'] ?? '');
$keyword   = htmlspecialchars($cek_web['keyword'] ?? '');

$pisah = explode('|', $title);
$judul = trim($pisah[0]);

$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https://' : 'http://';
$baseurl  = $protocol . $_SERVER['HTTP_HOST'];

function asset($path) {
    global $baseurl;
    return $baseurl . '/assets/' . ltrim($path, '/');
}

ob_start();

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$isMobile = preg_match('/(android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini)/i', $userAgent);

// Override via ?view=mobile/desktop
if (isset($_GET['view'])) {
    $isMobile = ($_GET['view'] === 'mobile');
}

define('DIR', __DIR__);
$viewFolder = $isMobile ? 'mobile' : 'desktop';
$viewFile = DIR . "/$viewFolder/index.php";

if (file_exists($viewFile)) {
    chdir(DIR . "/$viewFolder");
    require $viewFile;
    exit;
} else {
    http_response_code(404);
    echo "<h1>404 Not Found</h1><p>View file tidak ditemukan di: " . htmlspecialchars($viewFile) . "</p>";
    exit;
}
?>
