<?php
/////////////////////////////////////////
//  LICENSE GAMES BY     : SOFTGAMINGS //
//  SOURCE CODE BUILD BY : ZULHAYKER   //
//  COPYRIGHT @2024------ALL RESERVED  //
/////////////////////////////////////////

ob_start();
header('Content-Type: text/html; charset=UTF-8'); // Pastikan browser merender HTML
include "../function/connect.php";
error_reporting(E_ALL); 
ini_set('display_errors', 0); // Nonaktifkan tampilan error di browser
ini_set('log_errors', 1); // Aktifkan logging error
ini_set('error_log', 'playgame_error.log'); // Tentukan file log

// Fungsi untuk logging debug
function logDebug($message, $file = '../logs/playgame_debug.log') {
    $timestamp = date('Y-m-d H:i:s');
    // Pastikan direktori log ada dan dapat ditulis
    if (!file_exists(dirname($file))) {
        mkdir(dirname($file), 0777, true);
    }
    file_put_contents($file, "[$timestamp] $message\n", FILE_APPEND);
}

// Validasi parameter GET
if (!isset($_GET['p']) || !isset($_GET['provider']) || !isset($_GET['type']) || !isset($_GET['game'])) {
    $errorMessage = "Parameter tidak lengkap: " . json_encode($_GET);
    logDebug("Error: $errorMessage");
    ob_clean(); // Bersihkan buffer sebelum output
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}

// Sanitasi input
$getSession = mysqli_real_escape_string($koneksi, $_GET['p']);
$provider = mysqli_real_escape_string($koneksi, $_GET['provider']);
$getGamestype = mysqli_real_escape_string($koneksi, $_GET['type']);
$game = mysqli_real_escape_string($koneksi, $_GET['game']);

// Log parameter yang diterima
logDebug("Parameters received: session=$getSession, provider=$provider, type=$getGamestype, game=$game");

// Validasi format input
if (empty($getSession) || empty($provider) || empty($getGamestype) || empty($game)) {
    $errorMessage = "Parameter kosong: session=$getSession, provider=$provider, type=$getGamestype, game=$game";
    logDebug("Error: $errorMessage");
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}

// Ambil konfigurasi dari tabel config menggunakan prepared statement
$stmt = mysqli_prepare($koneksi, "SELECT url_request, agent_code, signature FROM config WHERE id = ?");
mysqli_stmt_bind_param($stmt, "i", $config_id);
$config_id = 1;
mysqli_stmt_execute($stmt);
$result_config = mysqli_stmt_get_result($stmt);
if (mysqli_num_rows($result_config) == 0) {
    $errorMessage = "Konfigurasi tidak ditemukan untuk id=1";
    logDebug("Error: $errorMessage");
    mysqli_stmt_close($stmt);
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}
$config = mysqli_fetch_assoc($result_config);
mysqli_stmt_close($stmt);

$url_request = $config['url_request'];
$agent_code = $config['agent_code'];
$signature = $config['signature'];

// Log konfigurasi yang diambil
logDebug("Config loaded: url_request=$url_request, agent_code=$agent_code, signature=$signature");

// Validasi konfigurasi
if (empty($url_request) || empty($agent_code) || empty($signature)) {
    $errorMessage = "Konfigurasi tidak lengkap: url_request=$url_request, agent_code=$agent_code, signature=$signature";
    logDebug("Error: $errorMessage");
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}

// Buat game_code
$game_code = $game; // Asumsi $game sudah merupakan game_code yang valid
logDebug("Generated game_code: $game_code");

// Buat payload untuk SGX API (game_launch)
$postArray = [
    'command' => 'game_launch',
    'agent_code' => $agent_code,
    'signature' => $signature,
    'user_code' => $getSession,
    'game_code' => $game_code
];
$jsonData = json_encode($postArray);

// Log payload yang dikirim
logDebug("API Request Payload: $jsonData");

// Kirim permintaan ke SGX API
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url_request);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$output = curl_exec($ch);

// Cek error cURL
if ($output === false) {
    $curlError = curl_error($ch);
    $errorMessage = "cURL Error: $curlError";
    logDebug("Error: $errorMessage");
    curl_close($ch);
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}
curl_close($ch);

// Log respon API
logDebug("API Response: $output");

// Parse respon dari SGX API
$openurl = json_decode($output, true);

// Cek apakah parsing JSON berhasil
if (json_last_error() !== JSON_ERROR_NONE) {
    $errorMessage = "JSON Parse Error: " . json_last_error_msg();
    logDebug("Error: $errorMessage");
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}

// Cek respon API
if (isset($openurl['status']) && $openurl['status'] == 200 && $openurl['message'] == 'SUCCESS' && isset($openurl['launch_url'])) {
    $gameUrl = $openurl['launch_url'];
    logDebug("Success: Redirecting to game URL: $gameUrl");
    ob_clean();
    header('Location: ' . $gameUrl);
    exit();
} elseif (isset($openurl['status']) && $openurl['message'] == 'UNDER_MAINTENANCE') {
    $errorMessage = "Game under maintenance";
    logDebug("Error: $errorMessage");
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Maintenance</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Maintenance",
                text: "Game ini sedang dalam perbaikan. Harap coba lagi nanti.",
                icon: "warning",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
} else {
    $errorMessage = isset($openurl['message']) ? $openurl['message'] : "Terjadi kesalahan dalam membuka game";
    logDebug("Error: API response error - $errorMessage");
    ob_clean();
    ?>
    <!DOCTYPE html>
    <html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Error</title>
    </head>
    <body>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Terjadi kesalahan dalam membuka game. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "OK"
            }).then(function() {
                window.location = "/index.php";
            });
        </script>
    </body>
    </html>
    <?php
    ob_end_flush();
    exit();
}
?>