<?php
/////////////////////////////////////////
//  LICENSE GAMES BY     : SOFTGAMINGS //
//  SOURCE CODE BUILD BY : ZULHAYKER   //
//  COPYRIGHT @2024------ALL RESERVED  //   
/////////////////////////////////////////



class zulhayker
{
    private $urlRequest;
    private $agentCode;
    private $signature;

    public function __construct($koneksi)
    {
        $config = $this->getConfigFromDatabase($koneksi);
        $this->urlRequest = $config['url_request'];
        $this->agentCode = $config['agent_code'];
        $this->signature = $config['signature'];
    }

    private function getConfigFromDatabase($koneksi)
    {
        $sql = "SELECT url_request, agent_code, signature FROM config WHERE id = 1";
        $result = mysqli_query($koneksi, $sql);

        $config = array();
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $config['url_request'] = $row['url_request'];
                $config['agent_code'] = $row['agent_code'];
                $config['signature'] = $row['signature'];
            }
        } else {
            die("Tidak ada data konfigurasi");
        }

        return $config;
    }

    public function Create($username)
    {
        $postArray = [
            'command' => 'user_create',
            'agent_code' => $this->agentCode,
            'signature' => $this->signature,
            'user_code' => $username
        ];
        return $this->connect($postArray);
    }

    public function Transaksi($username, $amount, $type)
    {
        $command = ($type == 'deposit') ? 'user_deposit' : 'user_withdraw';
        $postArray = [
            'command' => $command,
            'agent_code' => $this->agentCode,
            'signature' => $this->signature,
            'user_code' => $username,
            'amount' => $amount
        ];
        return $this->connect($postArray);
    }

    public function OpenGame($username, $game_provider, $game_type, $game_code)
    {
        $postArray = [
            'command' => 'game_launch',
            'agent_code' => $this->agentCode,
            'signature' => $this->signature,
            'user_code' => $username,
            'game_code' => $game_code
        ];
        return $this->connect($postArray);
    }

    public function GetBalance($username)
    {
        $postArray = [
            'command' => 'user_info',
            'agent_code' => $this->agentCode,
            'signature' => $this->signature,
            'user_code' => $username
        ];
        return $this->connect($postArray);
    }

    public function InfoAgent()
    {
        $postArray = [
            'command' => 'agent_info',
            'agent_code' => $this->agentCode,
            'signature' => $this->signature
        ];
        return $this->connect($postArray);
    }

    private function connect($postArray)
    {
        $jsonData = json_encode($postArray);
        $headerArray = ['Content-Type: application/json'];

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->urlRequest);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headerArray);
        curl_setopt($ch, CURLOPT_IPRESOLVE, CURL_IPRESOLVE_V4);
        curl_setopt($ch, CURLOPT_AUTOREFERER, TRUE);
        curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/51.0.2704.47 Safari/537.36');
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);

        $output = curl_exec($ch);
        curl_close($ch);
        return $output;
    }
}

$ZH = new zulhayker($koneksi);
?>