<?php
ob_start();
include "../function/connect.php";
error_reporting(E_ALL);
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', '../logs/update_provider_error.log');

// Fungsi untuk logging debug
function logDebug($message, $file = '../logs/update_provider.log') {
    $timestamp = date('Y-m-d H:i:s');
    if (!file_exists(dirname($file))) {
        mkdir(dirname($file), 0777, true);
    }
    file_put_contents($file, "[$timestamp] $message\n", FILE_APPEND);
}

// Log awal eksekusi
logDebug("Script started: update.php");

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update'])) {
    // Ambil konfigurasi dari tabel config
    $stmt = mysqli_prepare($koneksi, "SELECT url_request, agent_code, signature FROM config WHERE id = ?");
    $config_id = 1;
    mysqli_stmt_bind_param($stmt, "i", $config_id);
    mysqli_stmt_execute($stmt);
    $result_config = mysqli_stmt_get_result($stmt);
    if (mysqli_num_rows($result_config) == 0) {
        logDebug("Error: Konfigurasi tidak ditemukan untuk id=1");
        mysqli_stmt_close($stmt);
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak ditemukan. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    }
    $config = mysqli_fetch_assoc($result_config);
    mysqli_stmt_close($stmt);

    $url_request = $config['url_request'];
    $agent_code = $config['agent_code'];
    $signature = $config['signature'];

    logDebug("Config loaded: url_request=$url_request, agent_code=$agent_code, signature=$signature");

    // Validasi konfigurasi
    if (empty($url_request) || empty($agent_code) || empty($signature)) {
        $errorMessage = "Konfigurasi tidak lengkap: url_request=$url_request, agent_code=$agent_code, signature=$signature";
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Konfigurasi tidak lengkap. Hubungi administrator.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    }

    // Buat payload untuk SGX API (provider_list)
    $postArray = [
        'command' => 'provider_list',
        'agent_code' => $agent_code,
        'signature' => $signature
    ];
    $jsonData = json_encode($postArray);
    logDebug("API Request Payload: $jsonData");

    // Kirim permintaan ke SGX API
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url_request);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $output = curl_exec($ch);

    // Cek error cURL
    if ($output === false) {
        $curlError = curl_error($ch);
        $errorMessage = "cURL Error: $curlError";
        logDebug("Error: $errorMessage");
        curl_close($ch);
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Gagal terhubung ke server API. Silakan coba lagi nanti.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    }
    curl_close($ch);

    // Log respon API
    logDebug("API Response: $output");

    // Parse respon dari SGX API
    $response = json_decode($output, true);

    // Cek apakah parsing JSON berhasil
    if (json_last_error() !== JSON_ERROR_NONE) {
        $errorMessage = "JSON Parse Error: " . json_last_error_msg();
        logDebug("Error: $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "Respon server tidak valid. Silakan coba lagi.",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    }

    // Cek respon API
    if (isset($response['status']) && $response['status'] == 200 && $response['message'] == 'SUCCESS' && isset($response['providers'])) {
        // Hapus semua data di tb_provider
        $query = mysqli_query($koneksi, "TRUNCATE TABLE tb_provider");
        if (!$query) {
            $errorMessage = "Gagal menghapus data di tb_provider: " . mysqli_error($koneksi);
            logDebug("Error: $errorMessage");
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Error",
                    text: "Gagal menghapus data provider. Hubungi administrator.",
                    icon: "error",
                    confirmButtonText: "Ok"
                }).then(function() {
                    window.location = "?page=update_provider";
                });
            </script>
            <?php
            exit();
        }
        logDebug("Successfully truncated tb_provider");

        // Siapkan query untuk menyimpan provider
        $stmt = mysqli_prepare($koneksi, "INSERT INTO tb_provider (provider_code, provider_name, provider_status, provider_type, provider_image) VALUES (?, ?, ?, ?, ?)");
        if (!$stmt) {
            $errorMessage = "Gagal menyiapkan prepared statement: " . mysqli_error($koneksi);
            logDebug("Error: $errorMessage");
            ?>
            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
            <script type="text/javascript">
                Swal.fire({
                    title: "Error",
                    text: "Gagal menyiapkan query. Hubungi administrator.",
                    icon: "error",
                    confirmButtonText: "Ok"
                }).then(function() {
                    window.location = "?page=update_provider";
                });
            </script>
            <?php
            exit();
        }

        // Hitung jumlah provider yang berhasil disimpan
        $successCount = 0;
        foreach ($response['providers'] as $provider) {
            $provider_code = $provider['provider_code'];
            $provider_name = $provider['provider_name'];
            $provider_status = $provider['provider_status'];
            $provider_type = $provider['provider_type'];
            $provider_image = isset($provider['provider_image']) ? $provider['provider_image'] : null;

            mysqli_stmt_bind_param($stmt, "ssiss", $provider_code, $provider_name, $provider_status, $provider_type, $provider_image);
            if (mysqli_stmt_execute($stmt)) {
                $successCount++;
                logDebug("Inserted provider: code=$provider_code, name=$provider_name");
            } else {
                logDebug("Failed to insert provider: code=$provider_code, error=" . mysqli_stmt_error($stmt));
            }
        }
        mysqli_stmt_close($stmt);

        logDebug("Total providers inserted: $successCount");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Sukses",
                text: "Berhasil memperbarui <?php echo $successCount; ?> provider.",
                icon: "success",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    } else {
        $errorMessage = isset($response['message']) ? $response['message'] : "Gagal mengambil daftar provider dari API.";
        logDebug("Error: API response error - $errorMessage");
        ?>
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
        <script type="text/javascript">
            Swal.fire({
                title: "Error",
                text: "<?php echo htmlspecialchars($errorMessage, ENT_QUOTES, 'UTF-8'); ?>",
                icon: "error",
                confirmButtonText: "Ok"
            }).then(function() {
                window.location = "?page=update_provider";
            });
        </script>
        <?php
        exit();
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Update Provider</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8f9fa;
        }
        .container {
            margin-top: 50px;
            max-width: 600px;
        }
        .card {
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .btn-update {
            background-color: #007bff;
            border-color: #007bff;
            font-size: 1.2rem;
            padding: 10px 20px;
        }
        .btn-update:hover {
            background-color: #0056b3;
            border-color: #0056b3;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="card">
            <div class="card-header text-center">
                <h3>Update Daftar Provider</h3>
            </div>
            <div class="card-body text-center">
                <p>Klik tombol di bawah untuk memperbarui daftar provider dari API SGX.</p>
                <form method="POST">
                    <button type="submit" name="update" class="btn btn-update">Update</button>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@10"></script>
</body>
</html>