<?php 
include '../../function/connect.php';
include '../../main/integration.php';
session_start();
error_reporting(0);

$id_login = $_SESSION['id'];
$extplayer = $_SESSION['extplayer'];

if (isset($_POST['submit'])) {
    $bank = trim($_POST['bank']);
    $jumlah = trim($_POST['jumlah']);
    $keterangan = trim($_POST['keterangan']);
    $tanggal = date('Y-m-d H:i:s');

    $jumlah = str_replace(['IDR : ', '.'], '', $jumlah);
    if (!ctype_digit($jumlah)) {
        die("Jumlah tidak valid.");
    }
    $jumlah = filter_var($jumlah, FILTER_SANITIZE_NUMBER_INT);

    $bank = strip_tags(htmlspecialchars($bank, ENT_QUOTES, 'UTF-8'));
    $keterangan = strip_tags(htmlspecialchars($keterangan, ENT_QUOTES, 'UTF-8'));

    $cekQuery = "SELECT COUNT(*) as total FROM tb_transaksi WHERE id_user = ? AND transaksi = 'Withdraw' AND (status = 'Pending' OR status = 'Belum Bayar')";
    $stmt = $koneksi->prepare($cekQuery);
    $stmt->bind_param("s", $extplayer);
    $stmt->execute();
    $result = $stmt->get_result();
    $cek = $result->fetch_assoc();
    $stmt->close();

    if ($cek['total'] == 0) {
        $saldoQuery = "SELECT active FROM tb_saldo WHERE id_user = ?";
        $stmt = $koneksi->prepare($saldoQuery);
        $stmt->bind_param("s", $extplayer);
        $stmt->execute();
        $result = $stmt->get_result();
        $saldoData = $result->fetch_assoc();
        $stmt->close();

        $saldoAktif = $saldoData['active'];

        $queryMinWD = "SELECT min_wd FROM tb_web";
        $result = $koneksi->query($queryMinWD);
        $minWdData = $result->fetch_assoc();
        $minWd = $minWdData['min_wd'];

        if ($saldoAktif < $jumlah) {
            header("Location: /index.php?page=transaksi&pesan=18");
            exit();
        } elseif ($jumlah < $minWd) {
            header("Location: /index.php?page=transaksi&pesan=19");
            exit();
        }

        $turnoverQuery = "SELECT id_bonus FROM tb_turnover WHERE id_user = ?";
        $stmt = $koneksi->prepare($turnoverQuery);
        $stmt->bind_param("s", $extplayer);
        $stmt->execute();
        $result = $stmt->get_result();
        $turnoverData = $result->fetch_assoc();
        $stmt->close();

        if ($turnoverData) {
            $id_bonus = $turnoverData['id_bonus'];

            $bonusQuery = "SELECT bonus, turnover FROM tb_bonus WHERE id = ?";
            $stmt = $koneksi->prepare($bonusQuery);
            $stmt->bind_param("i", $id_bonus);
            $stmt->execute();
            $result = $stmt->get_result();
            $bonusData = $result->fetch_assoc();
            $stmt->close();

            $requiredTurnover = $bonusData['bonus'] * $bonusData['turnover'];

            if ($saldoAktif < $requiredTurnover) {
                header("Location: /index.php?page=transaksi&pesan=17");
                exit();
            }
        }

        $ZH->Transaksi($extplayer, $jumlah, 'withdraw');

        $insertQuery = "INSERT INTO tb_transaksi (id, gambar, tanggal, transaksi, total, dari_bank, metode, bonus, keterangan, status, id_user, trxid, expired, url) 
                        VALUES (NULL, '', ?, 'Withdraw', ?, ?, '', '', ?, 'Pending', ?, '0', ?, 'Zulhayker')";
        $stmt = $koneksi->prepare($insertQuery);
        $stmt->bind_param("sissss", $tanggal, $jumlah, $bank, $keterangan, $extplayer, $tanggal);
        $insertResult = $stmt->execute();
        $stmt->close();

        $updateBalanceQuery = "UPDATE tb_saldo SET active = active - ?, pending = pending + ? WHERE id_user = ?";
        $stmt = $koneksi->prepare($updateBalanceQuery);
        $stmt->bind_param("iis", $jumlah, $jumlah, $extplayer);
        $updateResult = $stmt->execute();
        $stmt->close();

        if ($insertResult && $updateResult) {
            header("Location: /index.php?page=transaksi&pesan=20");
            exit();
        }
    } else {
        header("Location: /index.php?page=transaksi&pesan=21");
        exit();
    }
}
?>
