
<div class="main-content game">
    <div class="container">
        <nav class="breadcrumb-container">
            <ul class="breadcrumb-list">
                <li class="breadcrumb-item" text="<?php echo $judul ?>" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self"><?php echo $judul ?></a>
                </li>
                <li class="breadcrumb-item" text="Live Games" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self">Live Games</a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="container">
            <div class="game__list">
                <div class="page-header">Live Games</div>
                <div class="game-list-container">
                    <?php
                    $games = [
                        ["provider" => "S6", "type" => "OT", "game" => "SV-LIVE-001", "title" => "SV388", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/other/sv388.webp", "status" => "active"],
                        ["provider" => "MW", "type" => "CB", "game" => "mw0", "title" => "MIKI WORLD", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/other/mki.webp", "status" => "active"],
                    ];
                    session_start();
                    $user = $_SESSION['username'] ?? null;
                    $extplayer = null;
                    if ($user) {
                        $getUser = mysqli_query($koneksi, "SELECT extplayer FROM tb_user WHERE username = '$user'");
                        $infouser = mysqli_fetch_array($getUser);
                        $extplayer = $infouser['extplayer'] ?? null;
                    }    
                    foreach ($games as $game) :
                        if (!$user) {
                            $link = "?pesan=28";
                        } else {
                            $link = $game['status'] === "maintenance"
                                ? "javascript:gameMaintenance()"
                                : $urlweb. "/main/PlayGame.php?p=" . $extplayer . "&provider=" . $game['provider'] . "&type=" . $game['type'] . "&game=" . $game['game'];
                        }
                         ?>
                        <div class="game-holder">
                            <a href="<?= $link ?>">
                                <div class="game-bottom"></div>
                                <div class="game-img">
                                    <img title="<?= $game['title'] ?>" alt="<?= $game['title'] ?>" src="<?= $game['image'] ?>">
                                    <div class="hover-play">
                                        <h6><?= $game['title'] ?></h6>
                                        <i class="fas fa-play"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="game__seo">
                <div hidden id="title-seo"><?= $judul ?>: Live Games</div>
                <div class="seo-content showFooter">
                    <h1>Live Games</h1>
                    <p>Live Games</p>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function gameMaintenance() {
            Swal.fire({
                title: 'Maintenance',
                text: 'Game ini sedang dalam perbaikan. Harap coba lagi nanti.',
                icon: 'warning',
                confirmButtonText: 'OK'
            });
        }
    </script>