<main id="main-route">
    <div class="main-content game">
    <div class="container">
        <nav class="breadcrumb-container">
            <ul class="breadcrumb-list">
                <li class="breadcrumb-item" text="<?php echo $judul ?>" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self"><?php echo $judul ?></a>
                </li>
                <li class="breadcrumb-item" text="Slot" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self">Slot</a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="container">
        <div class="game__list">
            <div class="page-header">Slot</div>
            <div class="game-list-container">
                <?php
                $slot_games = [
                    ["slug" => "pragmatic", "title" => "Pragmatic Play", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/pra.webp", "status" => "active"],
                    ["slug" => "pgsoft", "title" => "PG Soft", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/pgs.webp", "status" => "active"],
                    ["slug" => "fachai", "title" => "Fa Chai", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/fac.webp", "status" => "active"],
                    ["slug" => "playtech", "title" => "Playtech Slot", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/pla.webp", "status" => "active"],
                    ["slug" => "spadegaming", "title" => "Spade Gaming", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/spd.webp", "status" => "active"],
                    ["slug" => "nextspin", "title" => "Next Spin", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/nex.webp", "status" => "active"],
                    ["slug" => "nolimit", "title" => "No Limit City", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/nlc.webp", "status" => "active"],
                    ["slug" => "microgaming", "title" => "MicroGaming", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/mic.webp", "status" => "active"],
                    ["slug" => "joker", "title" => "Joker Gaming", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/jok.webp", "status" => "active"],
                    ["slug" => "jili", "title" => "Jili", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/jli.webp", "status" => "active"],
                    ["slug" => "jdb", "title" => "Jdb", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/jdb.webp", "status" => "active"],
                    ["slug" => "cq9", "title" => "Cq9", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/cq9.webp", "status" => "active"],
                    ["slug" => "habanero", "title" => "Habanero", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/hbn.webp", "status" => "active"],
                    ["slug" => "hydako", "title" => "Hydako", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/slot/hyd.webp", "status" => "active"],
                    ["slug" => "live22", "title" => "Live22", "image" => "$urlweb/uploads/provider/live22.png", "status" => "active"],
                    ["slug" => "playngo", "title" => "Play N Go", "image" => "$urlweb/uploads/provider/playngo.png", "status" => "active"],
                    ["slug" => "asiagaming", "title" => "Asia Gaming", "image" => "$urlweb/uploads/provider/asiagaming.png", "status" => "active"],
                    ["slug" => "worldmatch", "title" => "World Match", "image" => "$urlweb/uploads/provider/worldmatch.png", "status" => "active"],
                    ["slug" => "fungaming", "title" => "Fun Gaming", "image" => "$urlweb/uploads/provider/fungaming.png", "status" => "active"],
                    ["slug" => "bigpot", "title" => "BigPot", "image" => "$urlweb/uploads/provider/bigpot.png", "status" => "active"],
                    ["slug" => "yggdrasil", "title" => "YggDrasil", "image" => "$urlweb/uploads/provider/yggdrasil.png", "status" => "active"],
                    ["slug" => "nagagames", "title" => "Naga Games", "image" => "$urlweb/uploads/provider/nagagames.png", "status" => "active"],
                    ["slug" => "skywind", "title" => "Sky Wind", "image" => "$urlweb/uploads/provider/skywind.png", "status" => "active"],
                    ["slug" => "funkygames", "title" => "Funky Games", "image" => "$urlweb/uploads/provider/funkygames.png", "status" => "active"],
                    ["slug" => "evoplay", "title" => "Evoplay", "image" => "$urlweb/uploads/provider/evoplay.png", "status" => "active"],
                    ["slug" => "wowgaming", "title" => "Wow Gaming", "image" => "$urlweb/uploads/provider/wowgaming.png", "status" => "active"],
                    ["slug" => "netent", "title" => "NETENT", "image" => "$urlweb/uploads/provider/netent.png", "status" => "active"],
                    ["slug" => "bigtimegaming", "title" => "Big Time Gaming", "image" => "$urlweb/uploads/provider/bigtimegaming.png", "status" => "active"],
                    ["slug" => "redtiger", "title" => "Red Tiger", "image" => "$urlweb/uploads/provider/redtiger.png", "status" => "active"],
                ];
                foreach ($slot_games as $game) :
                    $link = $game['status'] === "maintenance"
                    ? "javascript:gameMaintenance()"
                    : "?page=" . $game['slug'];
                    ?>
                    <div class="game-holder">
                        <a href="<?= htmlspecialchars($link) ?>">
                            <div class="game-bottom"></div>
                            <div class="game-img">
                                <img title="<?= htmlspecialchars($game['title']) ?>" 
                                     alt="<?= htmlspecialchars($game['title']) ?>" 
                                     src="<?= htmlspecialchars($game['image']) ?>">
                                <div class="hover-play">
                                    <h6><?= htmlspecialchars($game['title']) ?></h6>
                                    <i class="fas fa-play"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="game__seo">
            <div hidden id="title-seo"><?php echo $judul ?>: Slot</div>
            <div class="seo-content showFooter">
                <h1>Slot</h1>
                <p>Slot</p>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function gameMaintenance() {
            Swal.fire({
                title: 'Maintenance',
                text: 'Game ini sedang dalam perbaikan. Harap coba lagi nanti.',
                icon: 'warning',
                confirmButtonText: 'OK'
            });
        }
    </script>
</main>