<div class="main-content game">
    <div class="container">
        <nav class="breadcrumb-container">
            <ul class="breadcrumb-list">
                <li class="breadcrumb-item">
                    <a href="<?= $url ?>" class="breadcrumb-link" target="_self"><?= $judul ?></a>
                </li>
                <li class="breadcrumb-item">
                    <a href="<?= $url ?>" class="breadcrumb-link" target="_self">Sports</a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="container">
            <div class="game__list">
                <div class="page-header">Sports</div>
                <div class="game-list-container">
                    <?php
                    $games = [
                        ["provider" => "AF", "type" => "SB", "game" => "afb0", "title" => "Afb88", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/sportbook/afb88.webp", "status" => "active"],
                        ["provider" => "CM", "type" => "SB", "game" => "cmd0", "title" => "Cmd368", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/sportbook/cmd368.webp", "status" => "active"],
                        ["provider" => "IA", "type" => "ES", "game" => "ia0", "title" => "IA Sports", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/sportbook/iae.webp", "status" => "active"]
                    ];
                    session_start();
                    $user = $_SESSION['username'] ?? null;
                    $extplayer = null;
                    if ($user) {
                        $getUser = mysqli_query($koneksi, "SELECT extplayer FROM tb_user WHERE username = '$user'");
                        $infouser = mysqli_fetch_array($getUser);
                        $extplayer = $infouser['extplayer'] ?? null;
                    }    
                    foreach ($games as $game) :
                        if (!$user) {
                            $link = "?pesan=28";
                        } else {
                            $link = $game['status'] === "maintenance"
                                ? "javascript:gameMaintenance()"
                                : $urlweb. "/main/PlayGame.php?p=" . $extplayer . "&provider=" . $game['provider'] . "&type=" . $game['type'] . "&game=" . $game['game'];
                        }
                         ?>
                        <div class="game-holder">
                            <a href="<?= $link ?>">
                                <div class="game-bottom"></div>
                                <div class="game-img">
                                    <img title="<?= $game['title'] ?>" alt="<?= $game['title'] ?>" src="<?= $game['image'] ?>">
                                    <div class="hover-play">
                                        <h6><?= $game['title'] ?></h6>
                                        <i class="fas fa-play"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="game__seo">
                <div hidden id="title-seo"><?= $judul ?>: Sports</div>
                <div class="seo-content showFooter">
                    <h1>Sports</h1>
                    <p>Sports</p>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function gameMaintenance() {
            Swal.fire({
                title: 'Maintenance',
                text: 'Game ini sedang dalam perbaikan. Harap coba lagi nanti.',
                icon: 'warning',
                confirmButtonText: 'OK'
            });
        }
    </script>
