<?php
if (!isset($_SESSION['extplayer']) || empty($_SESSION['extplayer'])) {
    header("Location: index.php?page=home");
    exit();
}
?>
<main id="main-route">
    <div class="main-content transaksi">
       <div class="container">
          <ul class="component-tabs nav nav-tabs" id="transactionTabs">
                <li class="nav-item">
                    <a class="button-pills nav-link active" id="nav-qris-tab" data-toggle="tab" href="#nav-qris" role="tab"
                       aria-controls="nav-qris" aria-selected="true">
                        <i class="fas fa-qrcode"></i>
                        <span>Deposit Qris</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="button-pills nav-link" id="nav-deposit-tab" data-toggle="tab" href="#nav-deposit"
                       role="tab" aria-controls="nav-deposit" aria-selected="false">
                        <i class="fas fa-wallet"></i>
                        <span>Deposit Manual</span>
                    </a>
                </li>
                <li class="nav-item">
                    <a class="button-pills nav-link" id="nav-withdraw-tab" data-toggle="tab" href="#nav-withdraw" role="tab"
                       aria-controls="nav-withdraw" aria-selected="false">
                        <i class="fas fa-coins"></i>
                        <span>Withdraw</span>
                    </a>
                </li>
</ul>
<div class="component-tab-content tab-content" id="pills-tabContent">
 <div class="tab-pane fade" id="nav-deposit" role="tabpanel" aria-labelledby="nav-deposit-tab">
    <div class="transaksi-grid">
       <div class="transaksi-payment">
        <?php
        $bank_online = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin' ");
        while ($dambe = mysqli_fetch_array($bank_online)) {
            ?>
            <div class="payment-item">
                <div class="payment-status online">ONLINE</div>
                <div class="payment-body">
                    <div class="payment-icon">
                        <img src="<?php echo $dambe['icon'] ?>" alt="<?php echo $dambe['nama_bank'] ?>">
                    </div>
                    <div class="payment-content">
                        <div class="title"><?php echo $dambe['nama_bank']; ?></div>
                        <div class="desc"></div>
                        <div class="desc">Deposit Min <?php echo isset($min_depo) ? $min_depo : '10,000'; ?></div>
                        <div class="desc"></div>
                    </div>
                </div>
            </div>
            <?php
        }
        ?>
    </div>
    <div class="transaksi-form">
      <form id="formDeposit" enctype="multipart/form-data" method="post" action="/mobile/function/deposit.php">
        <div class="transaksi-formulir flip-card">
            <div class="flip-front">
                <div class="formulir-title"><i class="fas fa-wallet"></i> | Formulir Deposit</div>
                <div class="formulir-form">
                    <?php
                    $queryzz = mysqli_query($koneksi, "SELECT * FROM tb_web");
                    $zzz = mysqli_fetch_array($queryzz);
                    $kode_unik = $zzz['kode_unik'];
                    ?>
                    <div class="row mb-3">
                        <div class="col-lg-12 d-flex flex-row">
                            <label class="note_addbank">Selalu pastikan rekening pengirim atau rekening tujuan sesuai dengan data yang terdaftar dan form deposit ini otomatis menggunakan kode unik<?php echo $zzz['kode_unik']; ?></label>
                        </div>
                    </div>
                    <div class="text-white" style="background: #0f1b39; color: #fff; padding: 20px 10px;">
                        <p>Dompet Utama</p>
                        <h5 class="text-warning">IDR <?php echo isset($liat['active']) ? number_format($liat['active'], 0, ',', '.') : '0'; ?></h5>    
                    </div>
                    <div class="form-group">
                        <div class="row">
                            <div class="col-lg-3 d-flex align-items-center">
                                <label>Nomor Rekening</label>
                            </div>
                            <div class="col-lg-6">
                                <span><?php 
                                if(isset($b['nama_bank'])) {
                                    echo $b['nama_bank']; ?> - <?php echo $b['nomor_rekening']; ?> - A.n (<?php echo $b['nama_pemilik'];
                                } else {
                                    echo "Data rekening tidak tersedia";
                                }
                                ?>)</span>
                                <input type="hidden" name="dari_bank" value="<?php echo isset($b['id']) ? $b['id'] : ''; ?>">
                            </div>
                        </div>
                    </div>
                    <div class="form-group ">
                        <div class="row">
                            <div class="col-lg-3 d-flex align-items-center">
                                <label>Jumlah Deposit</label>
                            </div>
                            <div class="col-lg-6">
                                <input name="nominal" required="" id="depositAmount" class="form-control" type="text" placeholder="50000">
                            </div>
                        </div>
                    </div>

                    <div class="form-group mb-0">
                        <div class="row">
                            <div class="col-lg-3 d-flex align-items-center">
                                <label>Pilih Bank</label>
                            </div>
                            <div class="col-lg-6">
                                <select  id="bankSelect" name="metode">
                                    <option value="" selected="" disabled="">--- Pilih Bank ---</option>
                                    <?php
                                    $query = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin'");
                                    while ($data = mysqli_fetch_array($query)) {
                                        $id_bank = $data['id'];
                                        $nama_bank = $data['nama_bank'];
                                        $nomor_rekening = $data['nomor_rekening'];
                                        $nama_pemilik = $data['nama_pemilik'];
                                        ?>
                                        <option value="<?php echo $id_bank; ?>"><?php echo $nama_bank; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    <?php
                    $querya = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin'");
                    while ($dataq = mysqli_fetch_array($querya)) {
                        $id_bank = $dataq['id'];
                        $nama_bank1 = $dataq['nama_bank'];
                        $nomor_rekening = $dataq['nomor_rekening'];
                        $nama_pemilik = $dataq['nama_pemilik'];
                        $icon = $dataq['icon'];
                        ?>
                        <div class="form-group bankOption" id="epayment-<?php echo $id_bank; ?>" style="display: none;">
                            <div class="row">
                                <div class="col-lg-3"></div>
                                <div class="qris-payment col-lg-6">
                                    <div class="card">
                                        <div class="card-header text-center p-1">
                                            <img class="img-fluid" style="max-height: 150px" src="<?php echo $icon ?>">
                                        </div>
                                        <div class="card-body text-dark" style="font-weight: 600; font-size: 11px;">
                                            <div class="row">
                                                <div class="col-6">
                                                    Nama Tujuan Akun:
                                                </div>
                                                <div class="col">
                                                    <?php echo $nama_pemilik; ?>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-6">
                                                    Nomor Akun Tujuan:
                                                </div>
                                                <div class="col-auto flex-shrink-1">
                                                    <a href="javascript:;" id="copyAddress-<?php echo $id_bank; ?>" data-clipboard-text="<?php echo $nomor_rekening; ?>">
                                                        <span><?php echo $nomor_rekening; ?></span>
                                                        <i class="far fa-copy ml-1" style="cursor: pointer;" title="Copy"></i>
                                                    </a>
                                               </div>
                                           </div>
                                           <div class="row">
                                            <div class="col-6">
                                                Min. Deposit:
                                            </div>
                                            <div class="col-6">
                                                IDR <?php echo isset($min_depo) ? number_format($min_depo, 0, ',', '.') : '10,000'; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php
                  }
                    ?>
                    <div class="form-group mb-0">
                        <div class="row">
                            <div class="col-lg-3 d-flex align-items-center">
                                <label>Pilih bonus</label>
                            </div>
                            <div class="col-lg-6">
                                <select  id="bonusSelect" name="bonus">
                                    <option value="tanpabonus" selected="" disabled="">--- Pilih bonus ---</option>
                                    <?php
                                    $query = mysqli_query($koneksi, "SELECT * FROM tb_bonus WHERE status = 'active'");
                                    while ($data = mysqli_fetch_array($query)) {
                                        $id_bonus = $data['id'];
                                        $judul = $data['judul'];
                                        ?>
                                        <option value="<?php echo $id_bonus; ?>"><?php echo $judul; ?></option>
                                        <?php
                                    }
                                    ?>
                                </select>
                            </div>
                        </div>
                    </div>
                    
                  <div class="form-group mb-0">
                      <div class="row">
                          <div class="col-lg-3 d-flex align-items-center">
                              <label for="buktiTransfer">Bukti Transfer</label>
                          </div>
                          <div class="col-lg-6">
                              <input type="file" name="bukti_transfer" id="buktiTransfer" class="form-control" required accept="image/*">
                          </div>
                      </div>
                  </div>
  
                  <div class="row mb-3">
                      <div class="col-lg-3 d-flex align-items-center">
                          <label style="font-size: 14px;" id="notesLabel">Keterangan</label>
                      </div>
                      <div class="col-lg-6">
                          <div id="chooseMode" class="">
                              <input id="notes" class="form-control"  name="keterangan" maxlength="100" type="text" placeholder="...">
                          </div>
                      </div>
                      <div class="col-lg-3">
                          <input type="hidden" name="phoneCreditMode" />
                          <label style="font-size: 10px;" class="formulir-desc">Maksimal 100 Karakter</label>
                      </div>
                  </div>
                  <div class="form-group text-center">
                      <div class="row">
                          <div class="col-lg-12">
                              <button name="submit" type="submit" class="btn-custom full_width">Kirim</button>
                          </div>
                      </div>    
                  </div>
              </div>
          </div>
      </div>
  </form>
</div>
</div>
<div class="transaksi-info">
   <div class="info-header">Informasi</div>
   <div class="info-content">
    <p>PERHATIKAN DENGAN SEKSAMA NOMOR REKENING TUJUAN SEBELUM TRANSFER !</p><p>Kami tidak memberikan toleransi apabila terjadi kesalahan transfer uang (Deposit) ke rekening yang tidak tertera di website <?php echo isset($judul) ? $judul : 'website'; ?>.</p><p>Minimal deposit : Rp.<?php echo isset($min_depo) ? number_format($min_depo, 0, ',', '.') : '10,000'; ?><br>Mohon Melakukan Deposit Menggunakan Kode Unik<br>Harap melakukan konfirmasi deposit 1x saja, dan tunggu permohonan anda diproses untuk dapat melakukan deposit selanjutnya.</p>Hubungi Whatsapp RESMI <?php echo isset($judul) ? $judul : 'website'; ?> : <a href="https://wa.me/<?php echo isset($whatsapp) ? $whatsapp : ''; ?>"><strong>+<?php echo isset($whatsapp) ? $whatsapp : ''; ?></strong></a></p>
</div>              
</div>
<div class="transaksi-table-bottom">
   <div class="bottom-form">
    <div class="row d-flex align-items-center">
        <div class="col-lg-8">
            <div class="form-title">Riwayat Deposit</div>
        </div>
    </div>
</div>
<div class="container-fluid table-dataTable">
    <table class="table table-hover" id="depositHistoryTable">
        <thead>
            <tr>
                <th>Tanggal</th>
                <th>Pembayaran Ke</th>
                <th>Jumlah</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $extplayer = isset($extplayer) ? $extplayer : '';
            if(!empty($extplayer)) {
                $query5 = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE id_user = '$extplayer' AND  transaksi = 'Top Up' ORDER BY id DESC LIMIT 7");
                while ($data1 = mysqli_fetch_array($query5)) {
                    ?>
                    <tr>
                        <td><?php echo $data1['tanggal']; ?></td>
                        <td><?php echo $data1['metode']; ?></td>
                        <td>Rp. <?php echo number_format($data1['total']); ?></td>
                        <td>
                            <?php 
                            if ($data1['status'] == 'Pending') {
                                ?>
                                <a class="btn btn-small btn-warning btn-sm">Pending</a>
                                <?php
                            }elseif ($data1['status'] == 'Sukses') {
                                ?>
                                <a class="btn btn-small btn-success btn-sm">Sukses</a>
                                <?php
                            }
                            elseif ($data1['status'] == 'Ditolak') {
                                ?>
                                <a class="btn btn-small btn-danger btn-sm">Ditolak</a>
                                <?php
                            }else{
                                echo $data1['status'];
                            }
                            ?>
                        </td>
                    </tr>
                    <?php
                }
            }
            ?>
        </tbody>
    </table>
</div>              
</div>
</div>

<!-- Improved QRIS Tab Content -->
<div class="tab-pane fade show active" id="nav-qris" role="tabpanel" aria-labelledby="nav-qris-tab">
    <div class="transaksi-grid">
        <div class="transaksi-payment">
            <div class="payment-item">
                <div class="payment-status online">ONLINE</div>
                <div class="payment-body">
                    <div class="payment-icon">
                        <img src="https://i.ibb.co.com/G42QckDS/1000438934-removebg-preview.png" alt="QRIS">
                    </div>
                    <div class="payment-content">
                        <div class="title">QRIS</div>
                        <div class="desc">Pembayaran Digital</div>
                        <div class="desc">Deposit Min <?php echo isset($min_depo) ? $min_depo : '10,000'; ?></div>
                    </div>
                </div>
            </div>
        </div>
        <div class="transaksi-form">
            <form id="depositForm">
                <div class="transaksi-formulir flip-card">
                    <div class="flip-front">
                        <div class="formulir-title"><i class="fas fa-qrcode"></i> | Deposit Otomatis</div>
                        <div class="formulir-form">
                            <div class="text-white" style="background: #0f1b39; color: #fff; padding: 20px 10px; margin-bottom: 15px; border-radius: 5px;">
                                <p>Dompet Utama</p>
                                <h5 class="text-warning">IDR <?php echo isset($liat['active']) ? number_format($liat['active'], 0, ',', '.') : '0'; ?></h5>    
                            </div>
                            
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-lg-3 d-flex align-items-center">
                                        <label>Username</label>
                                    </div>
                                    <div class="col-lg-6">
                                        <input type="text" class="form-control" name="username" value="<?php echo isset($punya_user['username']) ? $punya_user['username'] : ''; ?>" readonly>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <div class="row">
                                    <div class="col-lg-3 d-flex align-items-center">
                                        <label>Nominal Deposit</label>
                                    </div>
                                    <div class="col-lg-6">
                                        <input type="number" class="form-control" name="amount" placeholder="Masukkan Nominal" required min="1000">
                                        <small style="display: block; margin-top: 3px;">Minimal deposit Rp 10.000</small>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group text-center">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <button type="submit" class="btn-custom full_width">Kirim</button>
                                    </div>
                                </div>    
                            </div>
                            
                            <div id="qrcode" class="text-center mt-3"></div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Fixed Withdraw Tab Content -->
<div class="tab-pane fade" id="nav-withdraw" role="tabpanel" aria-labelledby="nav-withdraw-tab">
    <div class="transaksi-grid">
        <div class="transaksi-payment">
            <?php
            $bank_online = mysqli_query($koneksi, "SELECT * FROM tb_bank WHERE level = 'admin' ");
            while ($dambe = mysqli_fetch_array($bank_online)) {
                ?>
                <div class="payment-item">
                    <div class="payment-status online">ONLINE</div>
                    <div class="payment-body">
                        <div class="payment-icon">
                            <img src="<?php echo $dambe['icon'] ?>" alt="<?php echo $dambe['nama_bank'] ?>">
                        </div>
                        <div class="payment-content">
                            <div class="title"><?php echo $dambe['nama_bank']; ?></div>
                            <div class="desc">Min. Withdraw: Rp <?php echo isset($min_wd) ? number_format($min_wd, 0, ',', '.') : '10,000'; ?></div>
                        </div>
                    </div>
                </div>
                <?php
            }
            ?>
        </div>
        
        <div class="transaksi-form">
            <form id="formWithdraw" action="/mobile/function/withdraw.php" method="POST">
                <div class="transaksi-formulir">
                    <div class="formulir-title"><i class="fas fa-coins"></i> | Formulir Penarikan</div>
                    <div class="formulir-form">                        
                        <div class="form-group">
                            <div class="row">
                                <div class="col-lg-4">
                                    <label class="formulir-desc">Saldo yang dapat ditarik:</label>
                                    <div class="balance-wd">IDR <?php echo isset($liat['active']) ? number_format($liat['active'], 0, ',', '.') : '0'; ?></div>
                                    <input type="hidden" id="max_withdraw" value="<?php echo isset($liat['active']) ? $liat['active'] : 0; ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-lg-3 d-flex align-items-center">
                                    <label>Nominal Withdraw</label>
                                </div>
                                <div class="col-lg-6">
                                    <input name="jumlah" required id="withdrawAmount" class="form-control" type="number" 
                                           placeholder="Masukkan nominal" 
                                           min="<?php echo isset($min_wd) ? $min_wd : 10000; ?>">
                                    <small class="text-muted">Minimal: Rp <?php echo isset($min_wd) ? number_format($min_wd, 0, ',', '.') : '10,000'; ?></small>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-lg-3 d-flex align-items-center">
                                    <label>Keterangan</label>
                                </div>
                                <div class="col-lg-6">
                                    <input class="form-control" name="keterangan" maxlength="100" type="text" placeholder="(Opsional)">
                                </div>
                            </div>
                        </div>

                        <div class="form-group text-center">
                            <button type="submit" name="submit" class="btn-custom" id="submit-withdraw">Kirim Permintaan</button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="transaksi-info">
       <div class="info-header">Informasi</div>
       <div class="info-content">
        <p>Minimal Withdraw : Rp. <?php echo isset($min_wd) ? number_format($min_wd, 0, ',', '.') : '0'; ?></p>
        <p>Penarikan DANA Anda akan segera kami proses dengan sangat senang sekali Kami <?php echo isset($judul) ? $judul : 'website'; ?> Mengucapkan Terima Kasih. Kami tunggu Transaksi anda untuk selanjutnya.</p>
    </div>              
    </div>
    <div class="transaksi-table-bottom">
       <div class="bottom-form">
        <div class="row d-flex align-items-center">
            <div class="col-lg-8">
                <div class="form-title">Riwayat Withdraw</div>
            </div>
        </div>
    </div>
    <div class="container-fluid table-dataTable">
        <table class="table table-hover " id="withdrawHistoryTable">
            <thead>
                <tr>
                    <th>Tanggal</th>
                    <th>Deskripsi</th>
                    <th>Jumlah</th>
                    <th>Status</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                if(!empty($extplayer)) {
                    $query5 = mysqli_query($koneksi, "SELECT * FROM tb_transaksi WHERE id_user = '$extplayer' AND transaksi = 'Withdraw' ORDER BY id DESC LIMIT 7");
                    while ($data1 = mysqli_fetch_array($query5)) {
                        ?>
                        <tr>
                            <td><?php echo $data1['tanggal']; ?></td>
                            <td><?php echo $data1['transaksi']; ?></td>
                            <td>Rp. <?php echo number_format($data1['total']); ?></td>
                            <td>
                                <?php 
                                if ($data1['status'] == 'Pending') {
                                    ?>
                                    <a class="btn btn-small btn-warning btn-sm">Pending</a>
                                    <?php
                                }elseif ($data1['status'] == 'Sukses') {
                                    ?>
                                    <a class="btn btn-small btn-success btn-small ">Sukses</a>
                                    <?php
                                }else if ($data1['status'] == 'Ditolak') {
                                    ?>
                                    <a class="btn btn-small btn-danger btn-sm">Ditolak</a>
                                    <?php
                                }else{
                                    ?>
                                    <a href="" class="btn btn-small btn-danger btn-sm">Bayar</a>
                                    <?php
                                }
                                ?>
                            </td>
                        </tr>
                        <?php
                    }
                }
                ?>
            </tbody>
        </table>
    </div>              
    </div>
</div>

<!-- CSS Fixes -->
<style>
/* Add these styles to fix layout and responsive issues */

/* Fix for mobile responsiveness */
@media (max-width: 576px) {
  .transaksi-grid {
    display: block;
  }
  
  .transaksi-payment, .transaksi-form, .transaksi-info {
    width: 100%;
    margin-bottom: 20px;
  }
  
  .col-lg-3, .col-lg-6 {
    padding: 0 10px;
  }
  
  .form-group .row {
    margin-bottom: 10px;
  }
}

/* Fix for QR code display */
#qrcode img {
  max-width: 100%;
  height: auto;
}

/* Better form validation styling */
.form-control.is-invalid {
  border-color: #dc3545;
  padding-right: calc(1.5em + .75rem);
  background-image: url("data:image/svg+xml,%3csvg xmlns='http://www.w3.org/2000/svg' width='12' height='12' fill='none' stroke='%23dc3545' viewBox='0 0 12 12'%3e%3ccircle cx='6' cy='6' r='4.5'/%3e%3cpath stroke-linejoin='round' d='M5.8 3.6h.4L6 6.5z'/%3e%3ccircle cx='6' cy='8.2' r='.6' fill='%23dc3545' stroke='none'/%3e%3c/svg%3e");
  background-repeat: no-repeat;
  background-position: right calc(.375em + .1875rem) center;
  background-size: calc(.75em + .375rem) calc(.75em + .375rem);
}

/* Fix for payment option display */
.payment-item {
  margin-bottom: 10px;
}

/* Fix for bank selection display */
.bankOption {
  transition: display 0.3s ease;
}
</style>

<!-- Your existing scripts + fixes -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
// Fix 1: Format deposit amount input properly handling input events
document.addEventListener('DOMContentLoaded', function() {
    const depositAmountInput = document.getElementById('depositAmount');
    if (depositAmountInput) {
        depositAmountInput.addEventListener('input', function (e) {
            // Remove non-digit characters
            let value = e.target.value.replace(/\D/g, '');
            // Format number with thousands separator
            if (value) {
                value = new Intl.NumberFormat('id-ID').format(value);
            }
            e.target.value = value;
        });
    }

    // Fix 2: Handle deposit form submission properly
    const formDeposit = document.getElementById('formDeposit');
    if (formDeposit) {
        formDeposit.addEventListener('submit', function (e) {
            const depositAmountInput = document.getElementById('depositAmount');
            if (depositAmountInput) {
                depositAmountInput.value = depositAmountInput.value.replace(/\D/g, '');
            }
        });
    }

    // Fix 3: Improved clipboard copy functionality
    var copyAddressButtons = document.querySelectorAll('[id^="copyAddress"]');
    copyAddressButtons.forEach(function(btn) {
        btn.addEventListener('click', function() {
            var textToCopy = this.getAttribute('data-clipboard-text');
            
            if (navigator.clipboard && navigator.clipboard.writeText) {
                navigator.clipboard.writeText(textToCopy)
                    .then(function() {
                        alert('Nomor akun tujuan berhasil disalin: ' + textToCopy);
                    })
                    .catch(function(err) {
                        fallbackCopyTextToClipboard(textToCopy);
                    });
            } else {
                fallbackCopyTextToClipboard(textToCopy);
            }
        });
    });

    function fallbackCopyTextToClipboard(text) {
        var textarea = document.createElement('textarea');
        textarea.value = text;
        textarea.style.position = 'fixed';
        document.body.appendChild(textarea);
        textarea.select();
        try {
            document.execCommand('copy');
            alert('Nomor akun tujuan berhasil disalin: ' + text);
        } catch (err) {
            console.error('Fallback: Could not copy text: ', err);
            alert('Gagal menyalin text. Silakan coba lagi.');
        }
        document.body.removeChild(textarea);
    }

    // Fix 4: Improved bank selection functionality
    const bankSelect = document.getElementById('bankSelect');
    if (bankSelect) {
        bankSelect.addEventListener('change', function() {
            var selectedValue = this.value;
            var bankOptions = document.querySelectorAll('.bankOption');
            
            bankOptions.forEach(function(option) {
                option.style.display = 'none';
            });
            
            if (selectedValue) {
                const selectedBank = document.getElementById('epayment-' + selectedValue);
                if (selectedBank) {
                    selectedBank.style.display = 'block';
                }
            }
        });
    }

    // Fix 5: Validate withdraw form
    const formWithdraw = document.getElementById('formWithdraw');
    if (formWithdraw) {
        formWithdraw.addEventListener('submit', function(e) {
            if (!validateWithdraw()) {
                e.preventDefault();
            }
        });
    }

    // Fix 6: QRIS deposit form handling
    const depositForm = document.getElementById('depositForm');
    if (depositForm) {
        depositForm.addEventListener('submit', async function(e) {
            e.preventDefault();
            
            const qrcodeDiv = document.getElementById('qrcode');
            if (qrcodeDiv) {
                qrcodeDiv.innerHTML = '<p>Generating QR code...</p><div class="spinner-border text-primary" role="status"><span class="sr-only">Loading...</span></div>';
                
                const username = this.username.value;
                const amount = this.amount.value;
                const uuid = '7b0ce385-670e-443a-b0e9-58bfb8890544';

                try {
                    const response = await fetch('https://qris.otomatis.vip/api/generate', {
                        method: 'POST',
                        headers: {
                            'Accept': 'application/json',
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({
                            username: username,
                            amount: amount,
                            uuid: uuid,
                            bonus: '0',
                        })
                    });

                    const result = await response.json();
                    
                    if (result && result.status) {
                        const qrData = encodeURIComponent(result.data || '');
                        const qrUrl = `https://api.siputzx.my.id/api/tools/text2qr?text=${qrData}`;

                        qrcodeDiv.innerHTML = `
                            <div class="card p-3 mx-auto" style="max-width: 350px;">
                                <h4 class="mb-3">Scan QR Code</h4>
                                <img src="${qrUrl}" alt="QR Code" class="img-fluid mb-3" crossorigin="anonymous">
                                <div class="alert alert-success mb-0">
                                    <small>QR Code akan expired dalam 5 menit</small>
                                </div>
                            </div>
                        `;
                    } else {
                        qrcodeDiv.innerHTML = '<div class="alert alert-danger">Gagal generate QR code. Silakan coba lagi.</div>';
                    }
                } catch (error) {
                    qrcodeDiv.innerHTML = '<div class="alert alert-danger">Terjadi kesalahan. Silakan coba lagi.</div>';
                    console.error('Error:', error);
                }
            }
        });
    }
});

// Fix 7: Consolidated validateWithdraw function
function validateWithdraw() {
    const withdrawAmountInput = document.getElementById('withdrawAmount');
    if (!withdrawAmountInput) return false;
    
    const amount = parseFloat(withdrawAmountInput.value);
    const maxWithdrawInput = document.getElementById('max_withdraw');
    const maxWithdraw = maxWithdrawInput ? parseFloat(maxWithdrawInput.value) : 0;
    
    // Get min_wd value or use default 10000
    const minWithdrawEl = document.querySelector('script');
    let minWithdraw = 1000; // Default value
    
    if (isNaN(amount) || amount <= 0) {
        alert('Masukkan nominal yang valid');
        return false;
    }
    
    if (amount < minWithdraw) {
        alert('Nominal withdraw minimal Rp ' + minWithdraw.toLocaleString('id-ID'));
        return false;
    }
    
    if (amount > maxWithdraw) {
        alert('Saldo tidak mencukupi! Saldo Anda: Rp ' + maxWithdraw.toLocaleString('id-ID'));
        return false;
    }
    
    return confirm('Anda yakin ingin melakukan withdraw sebesar Rp ' + amount.toLocaleString('id-ID') + '?');
}
</script>