<?php
// Koneksi ke database
$servername = "localhost";
$username = "padmin_ijo";
$password = "padmin_ijo";
$dbname = "padmin_ijo";

// Buat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Cek koneksi
if ($conn->connect_error) {
    die("Koneksi gagal: " . $conn->connect_error);
}

// Ambil URL dari database
$sql = "SELECT url FROM tb_web WHERE id = 1"; // Ubah kondisi 'id = 1' sesuai kebutuhanmu
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Output data dari setiap baris
    $row = $result->fetch_assoc();
    $urlweb = $row["url"];
} else {
    // Jika tidak ada data, beri nilai default
    $urlweb = "http://localhost"; // Ubah dengan URL default-mu
}

$conn->close();

// CONFIG
$base_url = rtrim($urlweb, '/');
$directory = __DIR__;
$sitemap_file = __DIR__ . "/sitemap.xml";
$cache_file = __DIR__ . "/.sitemap_cache";

// Folder yang di-skip
$skip_folders = ['vendor', 'node_modules', 'config', 'storage', 'cache'];

// Waktu modifikasi terakhir di cache
$last_mod_cached = file_exists($cache_file) ? file_get_contents($cache_file) : 0;

// Cari waktu modifikasi terbaru dari semua file
$last_mod_current = 0;
$iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
foreach ($iterator as $file) {
    if ($file->isFile()) {
        $mtime = $file->getMTime();
        if ($mtime > $last_mod_current) {
            $last_mod_current = $mtime;
        }
    }
}

// Kalau ada perubahan file → regenerate sitemap
if ($last_mod_current > $last_mod_cached) {
    $urls = [];

    // Masukkan homepage paling pertama
    $urls[] = rtrim($base_url, '/') . '/';

    // Scan semua file
    foreach ($iterator as $file) {
        if ($file->isFile()) {
            $ext = strtolower(pathinfo($file->getFilename(), PATHINFO_EXTENSION));
            if (in_array($ext, ['html', 'php'])) {
                $path = str_replace($directory, '', $file->getPathname());
                $path = str_replace('\\', '/', $path);

                // Skip folder tertentu
                $skip = false;
                foreach ($skip_folders as $sf) {
                    if (strpos($path, "/$sf/") !== false) {
                        $skip = true;
                        break;
                    }
                }
                if ($skip) continue;

                // Buat URL
                $url = rtrim($base_url, '/') . $path;

                // Hapus /index.php di root
                if ($url === rtrim($base_url, '/') . '/index.php') {
                    continue; // sudah masuk sebagai homepage
                }

                $urls[] = $url;
            }
        }
    }

    // Hilangkan duplikat
    $urls = array_unique($urls);

    // Generate XML
    $xml = '<?xml version="1.0" encoding="UTF-8"?>' . "\n";
    $xml .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">' . "\n";
    foreach ($urls as $url) {
        $xml .= "  <url>\n";
        $xml .= "    <loc>{$url}</loc>\n";
        $xml .= "    <lastmod>" . date('Y-m-d') . "</lastmod>\n";
        $xml .= "    <changefreq>weekly</changefreq>\n";
        $xml .= "    <priority>0.8</priority>\n";
        $xml .= "  </url>\n";
    }
    $xml .= "</urlset>";

    // Simpan
    file_put_contents($sitemap_file, $xml);
    file_put_contents($cache_file, $last_mod_current);

    error_log("Sitemap regenerated at " . date('Y-m-d H:i:s'));
}
?>