<div class="main-content game">
    <div class="container game__slider">
        <div class="swiper-container game-category-slider">
            <div class="swiper-wrapper">
                <?php
                $query = mysqli_query($koneksi, "SELECT * FROM tb_bannerdesk WHERE status = 'active' LIMIT 1");
                if (!$query) {
                    die("Kueri gagal: " . mysqli_error($koneksi));
                }

                if ($data = mysqli_fetch_array($query)) {
                ?>
                <div class="swiper-slide">
                    <a href="#">
                        <img src="<?php echo htmlspecialchars($data['gambar']); ?>" alt="Banner Image">
                    </a>
                </div>
                <?php
                }
                ?>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    <div class="container">
        <nav class="breadcrumb-container">
            <ul class="breadcrumb-list">
                <li class="breadcrumb-item" text="<?php echo $judul ?>" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self"><?php echo $judul ?></a>
                </li>
                <li class="breadcrumb-item" text="Arcade" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self">Arcade</a>
                </li>
            </ul>
        </nav>
    </div>
    <div class="container">
        <div class="game__list">
            <div class="page-header">Arcade</div>
            <div class="game-list-container">
                <?php
                $slot_games = [
                    ["slug" => "spaceman", "title" => "Pragmatic Play LC", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/other/spa.webp", "status" => "active"],
                    ["slug" => "cq9arcade", "title" => "CQ9", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/cq9.webp", "status" => "active"],
                    ["slug" => "fachaiarcade", "title" => "FaChai", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/fac.webp", "status" => "active"],
                    ["slug" => "jdbarcade", "title" => "Jdb", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/jdb.webp", "status" => "active"],
                    ["slug" => "spadegamingarcade", "title" => "Spade Gaming", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/spd.webp", "status" => "active"],
                    ["slug" => "jokerarcade", "title" => "Joker", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/jok.webp", "status" => "active"],
                    ["slug" => "jiliarcade", "title" => "Jili", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/fishing/jli.webp", "status" => "active"],
                    ["slug" => "funkyarcade", "title" => "Funky Games", "image" => "$urlweb/uploads/provider/funkyarcade.png", "status" => "active"],
                    ["slug" => "microgamingarcade", "title" => "MicroGaming", "image" => "$urlweb/uploads/provider/microgamingarcade.png", "status" => "active"]
                ];
                foreach ($slot_games as $game) :
                    $link = $game['status'] === "maintenance"
                    ? "javascript:gameMaintenance()"
                    : "?page=" . $game['slug']; 
                    ?>
                    <div class="game-holder">
                        <a href="<?= htmlspecialchars($link) ?>">
                            <div class="game-bottom"></div>
                            <div class="game-img">
                                <img title="<?= htmlspecialchars($game['title']) ?>" 
                                     alt="<?= htmlspecialchars($game['title']) ?>" 
                                     src="<?= htmlspecialchars($game['image']) ?>">
                                <div class="hover-play">
                                    <h6><?= htmlspecialchars($game['title']) ?></h6>
                                    <i class="fas fa-play"></i>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <div class="game__seo">
            <div hidden id="title-seo"><?php echo $judul ?>: Arcade</div>
            <div class="seo-content showFooter">
                <h1>Arcade</h1>
                <p>Arcade</p>
            </div>
        </div>
    </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function gameMaintenance() {
            Swal.fire({
                title: 'Maintenance',
                text: 'Game ini sedang dalam perbaikan. Harap coba lagi nanti.',
                icon: 'warning',
                confirmButtonText: 'OK'
            });
        }
    </script>
</main>