
<div class="main-content game">
    <div class="container game__slider">
        <div class="swiper-container game-category-slider">
            <div class="swiper-wrapper">
                <?php
                $query = mysqli_query($koneksi, "SELECT * FROM tb_bannerdesk WHERE status = 'active' LIMIT 1");
                if (!$query) {
                    die("Kueri gagal: " . mysqli_error($koneksi));
                }

                if ($data = mysqli_fetch_array($query)) {
                ?>
                <div class="swiper-slide">
                    <a href="#">
                        <img src="<?php echo htmlspecialchars($data['gambar']); ?>" alt="Banner Image">
                    </a>
                </div>
                <?php
                }
                ?>
                <div class="swiper-pagination"></div>
            </div>
        </div>
    <div class="container">
        <nav class="breadcrumb-container">
            <ul class="breadcrumb-list">
                <li class="breadcrumb-item" text="<?php echo $judul ?>" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self"><?php echo $judul ?></a>
                </li>
                <li class="breadcrumb-item" text="Lottery" url="<?php echo $url ?>">
                    <a href="<?php echo $url ?>" class="breadcrumb-link" target="_self">Lottery</a>
                </li>
            </ul>
        </nav>
    </div>
    
    <div class="container">
            <div class="game__list">
                <div class="page-header">Lottery</div>
                <div class="game-list-container">
                    <?php
                    $games = [
                        ["provider" => "ND", "type" => "LK", "game" => "nd0", "title" => "Nex4D", "image" => "https://images.linkcdn.cloud/global/game-skin2/banner/lottery/tog.webp", "status" => "active"],
                        ["provider" => "QK", "type" => "LK", "game" => "qk0", "title" => "QQ Keno", "image" => "$urlweb/uploads/provider/qqkeno.png", "status" => "active"]                    
                    ];
                    session_start();
                    $user = $_SESSION['username'] ?? null;
                    $extplayer = null;
                    if ($user) {
                        $getUser = mysqli_query($koneksi, "SELECT extplayer FROM tb_user WHERE username = '$user'");
                        $infouser = mysqli_fetch_array($getUser);
                        $extplayer = $infouser['extplayer'] ?? null;
                    }    
                    foreach ($games as $game) :
                        if (!$user) {
                            $link = "?pesan=28";
                        } else {
                            $link = $game['status'] === "maintenance"
                                ? "javascript:gameMaintenance()"
                                : $urlweb. "/main/PlayGame.php?p=" . $extplayer . "&provider=" . $game['provider'] . "&type=" . $game['type'] . "&game=" . $game['game'];
                        }
                         ?>
                        <div class="game-holder">
                            <a href="<?= $link ?>">
                                <div class="game-bottom"></div>
                                <div class="game-img">
                                    <img title="<?= $game['title'] ?>" alt="<?= $game['title'] ?>" src="<?= $game['image'] ?>">
                                    <div class="hover-play">
                                        <h6><?= $game['title'] ?></h6>
                                        <i class="fas fa-play"></i>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="game__seo">
                <div hidden id="title-seo"><?= $judul ?>: Lottery</div>
                <div class="seo-content showFooter">
                    <h1>Lottery</h1>
                    <p>Lottery</p>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script>
        function gameMaintenance() {
            Swal.fire({
                title: 'Maintenance',
                text: 'Game ini sedang dalam perbaikan. Harap coba lagi nanti.',
                icon: 'warning',
                confirmButtonText: 'OK'
            });
        }
    </script>